package org.unitedfront2.web.controller.account;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.security.LockedException;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.Account;

/**
 * Acegi Security ̃OC⊮r[vGA[NXłB[UF؎sOA[U
 * ԂȂǁAʂɕKvȗvf Tiles XR[vɐݒ肵܂B
 *
 * @author kurokkie
 *
 */
@Repository(value = "accountLoginFormPreparer")
public class LoginFormPreparer implements ViewPreparer {

    /** ŌɃNGXgOC[ŨftHg */
    public static final String DEFAULT_LAST_USERNAME_KEY = "username";

    /** ŌɃNGXgۂ̗ÕftHg */
    public static final String DEFAULT_LAST_EXCEPTION_KEY
        = "authenticationException";

    /** AJEg̏Ԗ̃ftHg */
    public static final String DEFAULT_USER_STATUS_KEY = "userStatus";

    /** ŌɃNGXgOC[U */
    private String usernameKey = DEFAULT_LAST_USERNAME_KEY;

    /** AJEg̏ */
    private String userStatusKey = DEFAULT_USER_STATUS_KEY;

    /** ŌɃNGXgۂ̗O */
    private String exceptionKey = DEFAULT_LAST_EXCEPTION_KEY;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {

        if (hasSession(tilesContext)) {
            setUsername(tilesContext, attributeContext);
            setExceptionAndUserStatus(tilesContext, attributeContext);
        }
    }

    private boolean hasSession(TilesRequestContext tilesContext) {
        return tilesContext.getSessionScope().containsKey(
            AuthenticationProcessingFilter.SPRING_SECURITY_LAST_USERNAME_KEY);
    }

    private void setUsername(TilesRequestContext tilesContext,
        AttributeContext attributeContext) {

        Object username = tilesContext.getSessionScope().get(
            AuthenticationProcessingFilter.SPRING_SECURITY_LAST_USERNAME_KEY);
        if (username != null) {
            attributeContext.putAttribute(usernameKey, new Attribute(username));
        }
    }

    private void setExceptionAndUserStatus(TilesRequestContext tilesContext,
        AttributeContext attributeContext) {

        Object exception = tilesContext.getSessionScope().get(
            AbstractProcessingFilter.SPRING_SECURITY_LAST_EXCEPTION_KEY);
        if (exception != null) {
            attributeContext.putAttribute(exceptionKey,
                new Attribute(exception));
            if (exception instanceof LockedException) {
                attributeContext.putAttribute(userStatusKey,
                    new Attribute(Account.Status.LOCKED));
            }
        }
    }

    public void setExceptionKey(String exceptionKey) {
        this.exceptionKey = exceptionKey;
    }

    public void setUsernameKey(String usernameKey) {
        this.usernameKey = usernameKey;
    }

    public void setUserStatusKey(String userStatusKey) {
        this.userStatusKey = userStatusKey;
    }
}
