package org.unitedfront2.web.controller;

import java.util.Date;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageTable;
import org.unitedfront2.web.WebUtils;

/**
 * m点\p̃EBWFbgłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "informationWidgetPreparer")
public class InformationWidgetPreparer implements ViewPreparer {

    /** m点XVԊu (15) */
    public static final int REFLESH_TERM = 60 * 15 * 1000;

    /** OXV */
    private Date lastRefleshDate;

    /** m点 */
    private Message information;

    /** bZ[We[u */
    @Autowired private MessageTable messageTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {
        attributeContext.putAttribute("information",
            new Attribute(getInformation()));
    }

    private void update() {
        information = messageTable.findByCode(
                WebUtils.SYSTEM_INFORMATION_MESSAGE_CODE);
        lastRefleshDate = new Date();
    }

    private Message getInformation() {
        if (information == null
                || new Date().after(new Date(lastRefleshDate.getTime()
                        + REFLESH_TERM))) {
            update();
        }
        return information;
    }
}
