package org.unitedfront2.web.controller;

import com.octo.captcha.service.CaptchaService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.web.WebUtils;

/**
 * lF؋@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Controller
public class CaptchaAction extends MultiAction {

    /** lF؃T[rX */
    @Autowired
    private CaptchaService captchaService;

    /**
     * F؏t[XR[vɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event putAuthenticated(RequestContext context) {
        boolean authenticated = WebUtils.findUser(context) != null
            || context.getExternalContext().getSessionMap()
                .get("authenticated") != null;
        context.getFlowScope().put("authenticated", authenticated);
        return success();
    }

    /**
     * lF؂s܂B
     *
     * @param context {@link RequestContext}
     * @return F؂ɐΐCxgAsΎsCxg
     */
    public Event authenticate(RequestContext context) {
        boolean authenticated = captchaService.validateResponseForID(
                WebUtils.getSession(context).getId(),
                context.getRequestParameters().getRequired("captcha"));
        if (authenticated) {
            WebUtils.getSession(context).setAttribute("authenticated", true);
            return success();
        } else {
            context.getFlashScope().put("authenticationFailed", true);
            return error();
        }
    }
}
