package org.unitedfront2.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.ServletContext;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.context.ServletContextAware;

/**
 * bZ[Wt@CzuĂpXݒ\ {@link ResourceBundleMessageSource} 
 * B
 *
 * @author kurokkie
 *
 */
public class HierarchyMessageSource extends
        ReloadableResourceBundleMessageSource implements ServletContextAware,
        InitializingBean {

    /** {@link ServletContext} */
    private ServletContext servletContext;

    /** Tiles `t@CzuĂpX */
    private String baseDir;

    @Override
    public void afterPropertiesSet() {
        setBasenames();
    }

    private void setBasenames() {
        File baseDir = new File(servletContext.getRealPath(this.baseDir));
        Collection<File> files = FileUtils.listFiles(baseDir,
                new NameFileFilter("messages.properties"),
                TrueFileFilter.INSTANCE);
        List<String> list = new ArrayList<String>(files.size());
        for (File f : files) {
            String path = f.getAbsolutePath();
            list.add(path.substring(servletContext.getRealPath("/").length(),
                    path.length() - ".properties".length())
                    .replace(File.separatorChar, '/'));
        }
        String[] basenames = list.toArray(new String[list.size()]);
        super.setBasenames(basenames);
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /**
     * Tiles `t@CzuĂpXݒ肵܂Bj /WEB-INF/view
     *
     * @param baseDir@Tiles `t@CzuĂpX
     */
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }
}
