package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.unitedfront2.dao.FootmarkDao;
import org.unitedfront2.dao.FriendDao;
import org.unitedfront2.dao.FriendSubscriptionDao;
import org.unitedfront2.dao.SelfIntroductionDao;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AbstractResource;

/**
 * vtB[킷NXłBvtB[͈ȉ̏𖞂Kv܂B
 *
 * @invariant ${this.ownerId} equals ${this.selfIntroduction.ownerId}
 * @invariant ${this.readAccessControl} equals
 * ${this.selfIntroduction.readAccessControl}
 * @invariant ${this.writeAccessControl} equals
 * {@link org.unitedfront2.domain.accesscontrol.OwnerOnly}
 * @invariant ${this.selfIntroduction.writeAccessControl} equals
 * {@link org.unitedfront2.domain.accesscontrol.OwnerOnly}
 *
 * @author kurokkie
 *
 */
public class Profile extends AbstractResource implements Serializable, Domain {

    /** Ղۑb̃ftHg (1) */
    public static final int DEFAULT_FOOTMARK_LIFETIME = 60 * 60 * 24 * 31;

    /** ꃆ[ȖՂ}[Wԁibj̃ftHg (24) */
    public static final int DEFAULT_FOOTMARK_MERGE_SECONDS = 24 * 60 * 60;

    /** VAԍ */
    private static final long serialVersionUID = 6164839823617344324L;

    /** ȏЉ */
    private transient Message selfIntroduction;

    /** FB\ݒ̃[UZbg */
    private transient Set<SimpleUser> subscriptingUsers;

    /** FBXg */
    private transient List<SimpleUser> friends;

    /** ՃXg */
    private transient List<Footmark> footmarks;

    /** uOXg */
    private transient List<Blog> blogs;

    /** ȏЉf[^ANZXIuWFNg */
    private transient SelfIntroductionDao selfIntroductionDao;

    /** bZ[We[u */
    private transient MessageTable messageTable;

    /** uOe[u */
    private transient BlogTable blogTable;

    /** Ղ̃f[^ANZXIuWFNg */
    private transient FootmarkDao footmarkDao;

    /** FBf[^ANZXIuWFNg */
    private transient FriendDao friendDao;

    /** FB\݃f[^ANZXIuWFNg */
    private transient FriendSubscriptionDao friendSubscriptionDao;

    /** FB̗FB */
    private transient Set<SimpleUser> friendsOfFriends;

    /** Ղۑb */
    private transient int footmarkLifetime = DEFAULT_FOOTMARK_LIFETIME;

    /** ꃆ[ȖՂ}[Wԁibj */
    private transient int footmarkMergeSeconds = DEFAULT_FOOTMARK_MERGE_SECONDS;

    @Override
    protected boolean buildEqualsBuilder(EqualsBuilder eb, Object other) {
        if (!(other instanceof Profile)) {
            return false;
        }
        return super.buildEqualsBuilder(eb, other);
    }

    /**
     * FBXgw萔_ɕ܂B
     *
     * @param max ől
     */
    public void retrieveFriends(int max) {
        this.friends = friendDao.findRandomly(getOwnerId(), max);
    }

    /**
     * ${friendId} FBǂ𔻕ʂ܂B
     *
     * @param friendId FB̃[U ID
     * @return FBȂ <code>true</code> AFBłȂ <code>false</code>
     */
    public boolean isFriend(int friendId) {
        return friendDao.find(getOwnerId(), friendId) != null;
    }

    /**
     * ̃vtB[[Uɑ΂ėFB̐\݂s܂B
     *
     * @param userId \ޑ̃[U ID
     * @require ${this.isFriend(userId)} is false.
     * @require ${this.existFriendSubscription(userId)} is false.
     */
    public void subscribe(int userId) {
        friendSubscriptionDao.register(userId, getOwnerId());
    }

    /**
     * w肵FB\݂邩ǂ肵܂B
     *
     * @param userId \񂾃[U ID
     * @return FB\݂ꍇ <code>true</code> AȂ <code>false</code>
     */
    public boolean existFriendSubscription(int userId) {
        return friendSubscriptionDao.find(userId, getOwnerId()) != null;
    }

    /**
     * w肵[U̗FB\݂󂯓܂B
     *
     * @param userId \񂾑̃[U ID
     * @require ${this.existFriendSubscription(userId)} is true.
     * @ensure ${this.existFriendSubscription(userId)} is false.
     * @ensure ${this.isFriend(userId)} is true.
     */
    public void allowFriendSubscription(int userId) {
        friendSubscriptionDao.delete(getOwnerId(), userId);
        friendSubscriptionDao.delete(userId, getOwnerId());
        friendDao.register(getOwnerId(), userId);
        friendDao.register(userId, getOwnerId());
    }

    /**
     * FB\݂ۂ܂B
     *
     * @param userId \񂾑̃[U ID
     * @require ${this.existFriendSubscription(userId)} is true.
     * @ensure ${this.existFriendSubscription(userId)} is false.
     * @ensure ${this.isFriend(userId)} is false.
     */
    public void denyFriendSubscription(int userId) {
        friendSubscriptionDao.delete(getOwnerId(), userId);
        friendSubscriptionDao.delete(userId, getOwnerId());
    }

    /**
     * w肵FBFBXg܂B
     *
     * @param friendId FB̃[U ID
     * @require ${this.isFriend(friendId)} is true.
     * @ensure ${this.isFriend(friendId)} is false.
     */
    public void removeFriend(int friendId) {
        friendDao.delete(getOwnerId(), friendId);
        friendDao.delete(friendId, getOwnerId());
    }

    /**
     * ̃vtB[ɑՂt܂Bg̑Ղ͕t܂BÂՂ͍폜܂B
     *
     * @param userId Ղt郆[U
     */
    public void footmark(int userId) {
        if (getOwnerId() == userId) {
            return;
        }
        footmarkDao.register(this.getOwnerId(), userId);
        footmarkDao.deleteOld(footmarkLifetime);
    }

    public void footmark(User user) {
        if (user != null) {
            footmark(user.getId());
        }
    }

    /** L҂uO̒ŁAw肵[UQƂł̂𕜌܂B */
    public void retrieveBlogs(User user) {
        blogs = blogTable.findByOwnerId(getOwnerId());
        Set<Blog> dels = new HashSet<Blog>();
        for (Blog b : blogs) {
            if (!b.canRead(user)) {
                dels.add(b);
            }
        }
        for (Blog b : dels) {
            blogs.remove(b);
        }
    }

    /**
     * uȎSĂ̋L𕜌܂BLԍ͂On܂鐮ŁAID ̍~ɂȂ܂B
     *
     * @param no Jn_ƂȂLԍ
     * @param num 
     */
    public void retrieveBlogEntries(int no, int num) {
        for (Blog b : blogs) {
            b.retrieveEntries(no, num);
        }
    }

    public Message getSelfIntroduction() {
        if (selfIntroduction == null && selfIntroductionDao != null) {
            int messageId = selfIntroductionDao.findMessageId(getOwnerId());
            this.selfIntroduction = messageTable.find(messageId);
        }
        return selfIntroduction;
    }

    public Set<SimpleUser> getSubscriptingUsers() {
        if (subscriptingUsers == null && friendSubscriptionDao != null) {
            this.subscriptingUsers = friendSubscriptionDao.findByFromId(
                    getOwnerId());
        }
        return subscriptingUsers;
    }

    /**
     * FBXg擾܂BĂяoO {@link #retrieveFriends(int)} sĂ
     * BsȂꍇASĂ̗FB̃XgԂ܂B
     *
     * @return FBXg
     */
    public List<SimpleUser> getFriends() {
        if (friends == null && friendDao != null) {
            this.friends = new ArrayList<SimpleUser>(friendDao.findByUserId(
                    getOwnerId()));
        }
        return friends;
    }

    /**
     * Ղ̃XgA܂Bԓ̓ꃆ[ȖՂ̏d͏܂B
     *
     * @return ՃXg
     */
    public List<Footmark> getFootmarks() {
        if (footmarks == null && footmarkDao != null) {
            this.footmarks = merge(footmarkDao.findByOwnerId(getOwnerId()));
        }
        return footmarks;
    }

    /**
     * ԓ̑Ղ}[W܂B
     *
     * @param footmarks ՃXg
     * @return }[W̑ՃXg
     */
    private List<Footmark> merge(List<Footmark> footmarks) {
        List<Footmark> newFootmarks = new ArrayList<Footmark>();
    outter:
        for (int i = 0; i < footmarks.size(); i++) {
            User user = footmarks.get(i).getUser();
            for (int j = 0; j < i; j++) {
                if (!user.identify(footmarks.get(j).getUser())) {
                    continue;
                }
                long timeI = footmarks.get(i).getDate().getTime();
                long timeJ = footmarks.get(j).getDate().getTime();
                if ((timeJ - timeI) < footmarkMergeSeconds * 1000L) {
                    continue outter;
                }
            }
            newFootmarks.add(footmarks.get(i));
        }
        return newFootmarks;
    }

    public List<Blog> getBlogs() {
        if (blogs == null && blogTable != null) {
            blogs = blogTable.findByOwnerId(getOwnerId());
        }
        return blogs;
    }

    /**
     * ̗FBƁAFB̗FB܂ł擾܂B
     *
     * @return FBZbg
     */
    public Set<SimpleUser> getFriendsOfFriends() {
        if (friendsOfFriends == null && friendDao != null) {
            Set<SimpleUser> myFriends = friendDao.findByUserId(getOwnerId());
            Set<SimpleUser> set = new HashSet<SimpleUser>(myFriends);
            for (SimpleUser friend : myFriends) {
                set.addAll(friendDao.findByUserId(friend.getId()));
            }
            this.friendsOfFriends = set;
        }
        return friendsOfFriends;
    }

    public void setSelfIntroductionDao(
            SelfIntroductionDao selfIntroductionDao) {
        this.selfIntroductionDao = selfIntroductionDao;
    }

    public void setMessageTable(MessageTable messageTable) {
        this.messageTable = messageTable;
    }

    public void setBlogTable(BlogTable blogTable) {
        this.blogTable = blogTable;
    }

    public void setFootmarkDao(FootmarkDao footmarkDao) {
        this.footmarkDao = footmarkDao;
    }

    public void setFriendDao(FriendDao friendDao) {
        this.friendDao = friendDao;
    }

    public void setFriendSubscriptionDao(
            FriendSubscriptionDao friendSubscriptionDao) {
        this.friendSubscriptionDao = friendSubscriptionDao;
    }

    public void setFootmarkLifetime(int footmarkLifetime) {
        this.footmarkLifetime = footmarkLifetime;
    }

    public void setFootmarkMergeSeconds(int footmarkMergeSeconds) {
        this.footmarkMergeSeconds = footmarkMergeSeconds;
    }
}
