package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.accesscontrol.AccessControl;

/**
 * Xbh^̃R~jeBłB
 *
 * @invariant ${this.threads[<i>k</i>].ownerId} equals ${this.ownerId}
 * @invariant ${this.threads[<i>k</i>].readAccessControl} equals
 * ${this.readAccessControl}
 * @invariant ${this.threads[<i>k</i>].writeAccessControl} equals
 * ${this.writeAccessControl}
 * @invariant ${this.threads[<i>k</i>].postAccessControl} equals
 * ${this.postAccessControl}
 *
 * @author kurokkie
 *
 */
public class MultiThreadCommunity extends AbstractCommunity
    implements Serializable, Domain {

    /** VAԍ */
    private static final long serialVersionUID = -5904029361837475679L;

    public MultiThreadCommunity() {
        super();
    }

    public MultiThreadCommunity(Integer id, String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(id, code, overview, ownerId, readAccessControl,
                writeAccessControl, postAccessControl);
    }

    public MultiThreadCommunity(String code, Message overview,
            Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl, AccessControl postAccessControl) {
        super(code, overview, ownerId, readAccessControl, writeAccessControl,
                postAccessControl);
    }

    /**
     * XbhȂ΍폜łB
     *
     */
    @Override
    public boolean isDeletable() {
        return getThreads().isEmpty();
    }

    @Override
    public <C extends Community> boolean canChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            if (getId() == null) {
                return true;
            } else {
                return getThreads().size() <= 1;
            }
        }
        if (clazz == MultiThreadCommunity.class) {
            return true;
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    protected <C extends Community> C doChangeTo(Class<C> clazz) {
        if (clazz == SingleThreadCommunity.class) {
            return (C) getDomainFactory().prototype(new SingleThreadCommunity(
                    getId(), getCode(), getOverview(), getOwnerId(),
                    getReadAccessControl(), getWriteAccessControl(),
                    getPostAccessControl()));
        }
        if (clazz == MultiThreadCommunity.class) {
            return (C) this;
        } else {
            String message = "The community type '" + clazz.getClass().getName()
                 + "' not supported.";
            logger.error(message);
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    public Date getLastUpdateDate() {
        if (super.getLastUpdateDate() == null && getThreads() != null) {
            if (getThreads().isEmpty()) {
                setLastUpdateDate(getOverview().getRegistrationDate());
                return getLastUpdateDate();
            }
            for (Thread t : getThreads()) {
                t.retrieveEntries(0, 1);
            }
            Thread t = Collections.max(getThreads(), new Comparator<Thread>() {
                @Override
                public int compare(Thread t1, Thread t2) {
                    return t1.getLastUpdateDate().compareTo(
                            t2.getLastUpdateDate());
                }
            });
            setLastUpdateDate(t.getLastUpdateDate());
        }
        return super.getLastUpdateDate();
    }

    /**
     * XbhVKɓo^܂BXbh̍폜́A{@link Thread#delete()} ō폜ĂB
     *
     * @param thread Xbh
     * @return œnXbh
     */
    public Thread registerThread(Thread thread) {
        thread.store();
        getCommunityDao().registerThread(getId(), thread.getId());
        return thread;
    }
}
