package org.unitedfront2.domain.communication;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.CommunityDao;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;

/**
 * R~jeB̃e[uW[łB
 *
 * @author kurokkie
 *
 */
public class CommunityTable {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** R~jeBf[^ANZXIuWFNg */
    private CommunityDao communityDao;

    /**
     * R~jeBXgL̓e̍~Ŏ擾܂B
     *
     * @param no Jnԍ
     * @param num 擾R~jeB̍ő吔
     * @return R~jeBXg
     */
    public List<Community> find(int no, int num) {
        return communityDao.findOrderByLastUpdateDateDesc(no, num);
    }

    /**
     * ID ƂēnASȃR~jeBIuWFNg擾܂B
     *
     * @param id ID
     * @return R~jeBAȂꍇ <code>null</code>
     */
    public Community find(int id) {
        return communityDao.find(id);
    }

    /**
     * R~jeBQƌŎ擾܂B
     *
     * @param id ID
     * @param user [U
     * @return R~jeB
     * @throws AccessDeniedException ANZX
     */
    public Community findForRead(int id, User user)
        throws AccessDeniedException {
        Community c = find(id);
        if (c == null) {
            return null;
        } else {
            c.readAccess(user);
            return c;
        }
    }

    /**
     * R~jeBҏWŎ擾܂B
     *
     * @param id ID
     * @param user [U
     * @return R~jeB
     * @throws AccessDeniedException ANZX
     */
    public Community findForWrite(int id, User user)
        throws AccessDeniedException {
        Community c = find(id);
        if (c == null) {
            return null;
        } else {
            c.writeAccess(user);
            return c;
        }
    }

    /**
     * R~jeB𓊍eŎ擾܂B
     *
     * @param id ID
     * @param user [U
     * @return R~jeB
     * @throws AccessDeniedException ANZX
     */
    public Community findForPost(int id, User user)
        throws AccessDeniedException {
        Community c = find(id);
        if (c == null) {
            return null;
        } else {
            c.postAccess(user);
            return c;
        }
    }

    /**
     * R[hƂēnASȃR~jeBIuWFNg擾܂B
     *
     * @param code R[h
     * @return R~jeBAȂꍇ <code>null</code>
     */
    public Community findByCode(String code) {
        return communityDao.findByCode(code);
    }

    /**
     * w肵R[hR~jeBQƌŎ擾܂B
     *
     * @param code R[h
     * @param user [U
     * @return R~jeB
     * @throws AccessDeniedException ANZX
     */
    public Community findByCodeForRead(String code, User user)
        throws AccessDeniedException {
        Community c = findByCode(code);
        if (c == null) {
            return null;
        } else {
            c.readAccess(user);
            return c;
        }
    }

    /**
     * w肵R[hR~jeBҏWŎ擾܂B
     *
     * @param code R[h
     * @param user [U
     * @return R~jeB
     * @throws AccessDeniedException ANZX
     */
    public Community findByCodeForWrite(String code, User user)
        throws AccessDeniedException {
        Community c = findByCode(code);
        if (c == null) {
            return null;
        } else {
            c.writeAccess(user);
            return c;
        }
    }

    /**
     * w肵R[hR~jeB𓊍eŎ擾܂B
     *
     * @param code R[h
     * @param user [U
     * @return R~jeB
     * @throws AccessDeniedException ANZX
     */
    public Community findByCodeForPost(String code, User user)
        throws AccessDeniedException {
        Community c = findByCode(code);
        if (c == null) {
            return null;
        } else {
            c.postAccess(user);
            return c;
        }
    }

    /**
     * R~jeBXgL̍ŏIXV̍~Ŏ擾܂BԂR~jeBɂ͍ŏIXV
     * 肳ĂԂɂȂ܂B
     *
     * @param no Jnԍ
     * @param num 擾R~jeB̍ő吔
     * @return R~jeBXg
     */
    public List<Community> findOrderByLastUpdateDateDesc(int no, int num) {
        return communityDao.findOrderByLastUpdateDateDesc(no, num);
    }

    /**
     * [UɂJ̑SR~jeB̃Xgo^̍~Ŏ擾܂B
     *
     * @return R~jeBXg
     */
    public List<Community> findPublicCommunities() {
        return communityDao.findPublicCommunities();
    }

    /**
     * [UɂJ̃R~jeBw萔_Ɏ擾܂B
     *
     * @param max ő吔
     * @return R~jeBXg
     */
    public List<Community> findPublicCommunitiesRandomly(int max) {
        return communityDao.findPublicCommunitiesRandomly(max);
    }

    /**
     * Q̃R~jeBXg擾܂B
     *
     * @param userId [U ID
     * @return R~jeBXg
     */
    public List<Community> findMyCommunities(int userId) {
        return communityDao.findMyCommunies(userId);
    }

    /**
     * Q̃R~jeBXgŏIXV̍~Ŏ擾܂B
     *
     * @param userId [U ID
     * @return R~jeBXg
     */
    public List<Community> findMyCommunitiesOrderByLastUpdateDate(int userId) {
        List<Community> communities = findMyCommunities(userId);
        Collections.sort(communities, new Comparator<Community>() {
            @Override
            public int compare(Community c1, Community c2) {
                return c2.getLastUpdateDate().compareTo(c1.getLastUpdateDate());
            }
        });
        return communities;
    }

    public void setCommunityDao(CommunityDao communityDao) {
        this.communityDao = communityDao;
    }
}
