package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.BlogDao;
import org.unitedfront2.domain.Deletable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.Storable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;

/**
 * uŐL\hCNXłB
 *
 * @author kurokkie
 *
 */
public class BlogEntry implements Serializable, Identifiable<BlogEntry>,
    Storable, Deletable, Domain {

    /** O */
    protected final transient Log logger = LogFactory.getLog(getClass());

    /** VAԍ */
    private static final long serialVersionUID = 8962368517170431378L;

    /** L */
    private Message entry;

    /** RgXg */
    private transient List<Comment> comments;

    /** Rg */
    private transient Integer commentCount;

    /** uOf[^ANZXIuWFNg */
    private transient BlogDao blogDao;

    public BlogEntry() {
        super();
    }

    public BlogEntry(Message entry) {
        super();
        this.entry = entry;
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof BlogEntry)) {
            return false;
        }
        BlogEntry castOther = (BlogEntry) other;
        return new EqualsBuilder()
            .append(entry, castOther.entry).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(entry).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("entry", entry).toString();
    }

    @Override
    public boolean identify(BlogEntry other) {
        if (entry == null) {
            return false;
        }
        return entry.identify(other.entry);
    }

    /**
     * L̐VKe {@link Blog#post(BlogEntry)} 𗘗pĂB
     */
    @Override
    public void store() {
        try {
            entry.store();
        } catch (MessageCodeUsedByOtherException e) {
            // NȂBL̃R[h͎B
            logger.error(e.getMessage(), e);
            throw new IllegalStateException(e);
        }
    }

    /**
     * LƃRgSč폜܂B
     */
    @Override
    public void delete() {
        entry.delete();
    }

    //**************************************************************************
    // Message Ϗ\bh
    //**************************************************************************
    public boolean canReadAccess() {
        return entry.canRead();
    }

    public boolean canReadAccess(int userId) {
        return entry.canRead(userId);
    }

    public boolean canWriteAccess() {
        return entry.canWrite();
    }

    public boolean canWriteAccess(int userId) {
        return entry.canWrite(userId);
    }

    public User getAuthor() {
        return entry.getAuthor();
    }

    public Integer getAuthorId() {
        return entry.getAuthorId();
    }

    public String getCode() {
        return entry.getCode();
    }

    public Integer getId() {
        return entry.getId();
    }

    public Date getRegistrationDate() {
        return entry.getRegistrationDate();
    }

    public Date getLastUpdateDate() {
        return entry.getLastUpdateDate();
    }

    public User getOwner() {
        return entry.getOwner();
    }

    public Integer getOwnerId() {
        return entry.getOwnerId();
    }

    public AccessControl getReadAccessControl() {
        return entry.getReadAccessControl();
    }

    public void setReadAccessControl(AccessControl readAccessControl) {
        entry.setReadAccessControl(readAccessControl);
    }

    public AccessControl getWriteAccessControl() {
        return entry.getWriteAccessControl();
    }

    public void setWriteAccessControl(AccessControl writeAccessControl) {
        entry.setWriteAccessControl(writeAccessControl);
    }

    public MessageEntry getRequiredEntry() {
        return entry.getRequiredEntry();
    }

    public void readAccess() throws AccessDeniedException {
        entry.readAccess();
    }

    public void readAccess(int userId) throws AccessDeniedException {
        entry.readAccess(userId);
    }

    public void readAccess(User user) throws AccessDeniedException {
        entry.readAccess(user);
    }

    public void writeAccess() throws AccessDeniedException {
        entry.writeAccess();
    }

    public void writeAccess(int userId) throws AccessDeniedException {
        entry.writeAccess(userId);
    }

    public void writeAccess(User user) throws AccessDeniedException {
        entry.writeAccess(user);
    }

    /**
     * Rg𓊍e܂BRgۑÃuOLƊ֘At܂B
     *
     * @param comment Rg
     */
    public void post(Comment comment) {
        comment.store();
        blogDao.registerComment(getId(), comment.getId());
    }

    /**
     * Rg擾܂B
     *
     * @param id Rg ID
     * @return RgAȂ <code>null</code>
     */
    public Comment findComment(int id) {
        for (Comment c : getComments()) {
            if (c.getId() == id) {
                return c;
            }
        }
        return null;
    }

    public Message getEntry() {
        return entry;
    }

    public void setEntry(Message entry) {
        this.entry = entry;
    }

    public List<Comment> getComments() {
        if (comments == null && blogDao != null && getId() != null) {
            comments = blogDao.findComments(getId());
        }
        return comments;
    }

    public Integer getCommentCount() {
        if (commentCount == null && blogDao != null && getId() != null) {
            commentCount = blogDao.countComment(getId());
        }
        return commentCount;
    }

    public void setBlogDao(BlogDao blogDao) {
        this.blogDao = blogDao;
    }
}
