package org.unitedfront2.domain.accesscontrol;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.User;

/**
 * ۓIȎłB
 *
 * @author kurokkie
 *
 */
public abstract class AbstractResource implements Resource, Serializable {

    /** VAԍ */
    private static final long serialVersionUID = -3745602238088175697L;

    /** O */
    protected final transient Log logger = LogFactory.getLog(getClass());

    /** ̏L */
    private Integer ownerId;

    /** Qƌ */
    private AccessControl readAccessControl;

    /** ҏW */
    private AccessControl writeAccessControl;

    /** ̏L */
    private transient SimpleUser owner;

    /** [Ue[u */
    private transient SimpleUserTable simpleUserTable;

    public AbstractResource() {
        super();
    }

    public AbstractResource(Integer ownerId, AccessControl readAccessControl,
            AccessControl writeAccessControl) {
        super();
        this.ownerId = ownerId;
        this.readAccessControl = readAccessControl;
        this.writeAccessControl = writeAccessControl;
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        buildToStringBuilder(tsb);
        return tsb.toString();
    }

    /**
     * {@link ToStringBuilder} ɃvpeBݒ肵܂B̎ł́AL ID AQƌA
     * ҏWݒ肵Ă܂B
     *
     * @param tsb {@link ToStringBuilder}
     */
    protected void buildToStringBuilder(ToStringBuilder tsb) {
        tsb.append("ownerId", ownerId)
            .append("readAccessControl", readAccessControl)
            .append("writeAccessControl", writeAccessControl);
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Resource)) {
            return false;
        }
        EqualsBuilder eb = new EqualsBuilder();
        if (!buildEqualsBuilder(eb, other)) {
            return false;
        }
        return eb.isEquals();
    }

    /**
     * {@link EqualsBuilder} ɃvpeBݒ肵܂B̎ł́AL ID AQƌAҏW
     * ݒ肵Ă܂B
     *
     * @param eb {@link EqualsBuilder}
     * @param other rΏۂ̃IuWFNg
     * @return {@link EqualsBuilder} ̍\zr {@link #equals(Object)} 
     * <code>false</code> ԂׂƔfł <code>false</code> AłȂ
     * <code>true</code>
     */
    protected boolean buildEqualsBuilder(EqualsBuilder eb, Object other) {
        if (!(other instanceof AbstractResource)) {
            return false;
        }
        AbstractResource castOther = (AbstractResource) other;
        eb.append(ownerId, castOther.getOwnerId())
            .append(readAccessControl, castOther.getReadAccessControl())
            .append(writeAccessControl, castOther.getWriteAccessControl());
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        buildHashCodeBuilder(hcb);
        return hcb.toHashCode();
    }

    /**
     * {@link HashCodeBuilder} ɃvpeBݒ肵܂B̎ł́AL ID AQƌA
     * ҏWݒ肵Ă܂B
     *
     * @param hcb {@link HashCodeBuilder}
     */
    protected void buildHashCodeBuilder(HashCodeBuilder hcb) {
        hcb.append(ownerId)
            .append(readAccessControl)
            .append(writeAccessControl);
    }

    @Override
    public void readAccess() throws AccessDeniedException {
        readAccessControl.access(this);
    }

    @Override
    public boolean canRead() {
        try {
            readAccess();
            return true;
        } catch (AccessDeniedException e) {
            if (logger.isInfoEnabled()) {
                logger.info(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public void readAccess(int userId) throws AccessDeniedException {
        readAccessControl.access(this, userId);
    }

    @Override
    public boolean canRead(int userId) {
        try {
            readAccess(userId);
            return true;
        } catch (AccessDeniedException e) {
            if (logger.isInfoEnabled()) {
                logger.info(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public void readAccess(User user) throws AccessDeniedException {
        if (user == null) {
            readAccess();
        } else {
            readAccess(user.getId());
        }
    }

    @Override
    public boolean canRead(User user) {
        if (user == null) {
            return canRead();
        } else {
            return canRead(user.getId());
        }
    }

    @Override
    public void writeAccess() throws AccessDeniedException {
        writeAccessControl.access(this);
    }

    @Override
    public boolean canWrite() {
        try {
            writeAccess();
            return true;
        } catch (AccessDeniedException e) {
            if (logger.isInfoEnabled()) {
                logger.info(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public void writeAccess(int userId) throws AccessDeniedException {
        writeAccessControl.access(this, userId);
    }

    @Override
    public boolean canWrite(int userId) {
        try {
            writeAccess(userId);
            return true;
        } catch (AccessDeniedException e) {
            if (logger.isInfoEnabled()) {
                logger.info(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public void writeAccess(User user) throws AccessDeniedException {
        if (user == null) {
            writeAccess();
        } else {
            writeAccess(user.getId());
        }
    }

    @Override
    public boolean canWrite(User user) {
        if (user == null) {
            return canWrite();
        } else {
            return canWrite(user.getId());
        }
    }

    @Override
    public Integer getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public AccessControl getReadAccessControl() {
        return readAccessControl;
    }

    public void setReadAccessControl(AccessControl readAccessControl) {
        this.readAccessControl = readAccessControl;
    }

    public AccessControl getWriteAccessControl() {
        return writeAccessControl;
    }

    public void setWriteAccessControl(AccessControl writeAccessControl) {
        this.writeAccessControl = writeAccessControl;
    }

    public SimpleUser getOwner() {
        if (owner == null && simpleUserTable != null && ownerId != null) {
            this.owner = simpleUserTable.find(ownerId);
        }
        return owner;
    }

    protected SimpleUserTable getSimpleUserTable() {
        return simpleUserTable;
    }

    public void setSimpleUserTable(SimpleUserTable simpleUserTable) {
        this.simpleUserTable = simpleUserTable;
    }
}
