package org.unitedfront2.domain;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.WidgetDao;

/**
 * EBWFbge[uW[łB
 *
 * @author kurokkie
 *
 */
public class WidgetTable implements Installer {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** EBWFbg̃f[^ANZXIuWFNg */
    private WidgetDao widgetDao;

    /**
     * @param userId [U ID
     * @require ${userId} exists.
     * @ensure ${this.get(userId).contains(Widget.GOOGLE_SEARH)} is true.
     */
    @Override
    public void install(int userId) {
        List<Widget> widgetList = new ArrayList<Widget>();
        widgetList.add(Widget.GOOGLE_SEARCH);
        store(userId, widgetList);
    }

    /**
     * EBWFbgXg擾܂B
     *
     * @param userId [U ID
     * @return EBWFbgXg
     */
    public List<Widget> find(int userId) {
        return widgetDao.find(userId);
    }

    /**
     * EBWFbgXgi܂BXg̏̂܂ܕ\ɂȂ܂B
     *
     * @param userId [U ID
     * @param widgets EBWFbgXg
     * @require ${userId} exist.
     * @ensure ${widgets} equals ${this.get(userId)}
     */
    public void store(int userId, List<Widget> widgets) {
        widgetDao.update(userId, widgets);
    }

    public void setWidgetDao(WidgetDao widgetDao) {
        this.widgetDao = widgetDao;
    }
}
