package org.unitedfront2.dao.jdbc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.FriendDao;
import org.unitedfront2.domain.SimpleUser;

/**
 * {@link FriendDao}  JDBC łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "friendDao")
public class FriendDaoImpl extends DaoSupport implements FriendDao {

    /** [U}bp[t@Ng */
    @Resource(name = "simpleUserDao")
    private RowMapperFactory<SimpleUser> simpleUserRowMapperFactory;

    @Override
    public void delete(int userId, int deleteId) {
        getSimpleJdbcTemplate().update(
                "DELETE FROM Friend WHERE UserId = ? AND FriendId = ?", userId,
                deleteId);
    }

    @Override
    public SimpleUser find(int userId, int friendId) {
        try {
            return getSimpleJdbcTemplate().queryForObject(
                    "SELECT * FROM Friend, User WHERE Friend.UserId = ? AND "
                    + "Friend.FriendId = ? AND Friend.FriendId = User.Id",
                    simpleUserRowMapperFactory.createRowMapper(), userId,
                    friendId);
        } catch (EmptyResultDataAccessException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    @Override
    public Set<SimpleUser> findByUserId(int userId) {
        return new HashSet<SimpleUser>(getSimpleJdbcTemplate().query(
                "SELECT * FROM Friend, User WHERE Friend.UserId = ? AND "
                + "Friend.FriendId = User.Id",
                simpleUserRowMapperFactory.createRowMapper(), userId));
    }

    @Override
    public List<SimpleUser> findRandomly(int userId, int max) {
        if (max <= 0) {
            String message = "The max must be over zero.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        return getSimpleJdbcTemplate().query(
                "SELECT * FROM Friend, User WHERE Friend.UserId = ? AND "
                + "Friend.FriendId = User.Id ORDER BY RAND() LIMIT 0, ?",
                simpleUserRowMapperFactory.createRowMapper(), userId, max);
    }

    @Override
    public void register(int userId, int friendId) {
        if (userId == friendId) {
            String message = "Cannot to be friend myself. [userId=" + userId
                + ",friendId=" + friendId + "]";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        getSimpleJdbcTemplate().update(
                "INSERT INTO Friend(UserId, FriendId) VALUES(?, ?)", userId,
                friendId);
    }
}
