package org.unitedfront2.dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.EmailForwardingDao;
import org.unitedfront2.domain.EmailForwarding;

/**
 * {@link EmailForwardingDao} ̃f[^ANZXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "emailForwardingDao")
public class EmailForwardingDaoImpl extends DaoSupport
    implements EmailForwardingDao {

    /** ]ݒ}bp[ */
    private static class EmailForwardingRowMapper
        implements ParameterizedRowMapper<Map<EmailForwarding, Boolean>> {

        @Override
        public Map<EmailForwarding, Boolean> mapRow(ResultSet rs, int rowNum)
            throws SQLException {
            Map<EmailForwarding, Boolean> map
                = new HashMap<EmailForwarding, Boolean>();
            for (EmailForwarding f : EmailForwarding.values()) {
                map.put(f, rs.getBoolean(toColumnName(f)));
            }
            return map;
        }
    }

    private static String toColumnName(EmailForwarding f) {
        String[] parts = f.toString().split("_");
        StringBuffer sb = new StringBuffer();
        for (String s : parts) {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() > 1) {
                sb.append(s.substring(1).toLowerCase(Locale.ENGLISH));
            }
        }
        return sb.toString();
    }

    @Override
    public void register(int userId) {
        getSimpleJdbcTemplate().update(
            "INSERT INTO EmailForwarding(UserId) VALUES(?)", userId);
    }

    @Override
    public Map<EmailForwarding, Boolean> find(int userId) {
        return getSimpleJdbcTemplate().queryForObject(
                "SELECT * FROM EmailForwarding WHERE UserId = ?",
                new EmailForwardingRowMapper(), userId);
    }

    @Override
    public boolean find(int userId, EmailForwarding forwarding) {
        return getSimpleJdbcTemplate().queryForObject("SELECT "
                + toColumnName(forwarding)
                + " FROM EmailForwarding WHERE UserId = ?", Boolean.class,
                userId);
    }

    @Override
    public void update(int userId, Map<EmailForwarding, Boolean> map) {
        StringBuffer sb = new StringBuffer("UPDATE EmailForwarding SET ");
        boolean first = true;
        for (Entry<EmailForwarding, Boolean> e : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(toColumnName(e.getKey()));
            sb.append(" = :");
            sb.append(e.getKey());
        }
        getSimpleJdbcTemplate().update(sb.toString(), toStringKeyMap(map));
    }

    private Map<String, Boolean> toStringKeyMap(
            Map<EmailForwarding, Boolean> map) {
        Map<String, Boolean> m = new HashMap<String, Boolean>(map.size());
        for (Entry<EmailForwarding, Boolean> e : map.entrySet()) {
            m.put(e.getKey().toString(), e.getValue());
        }
        return m;
    }
}
