package org.unitedfront2.dao;

import java.util.List;

import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.Comment;

/**
 * uÕf[^ANZXC^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface BlogDao extends Registerable<Blog>, SimpleFindable<Blog>,
        Updatable<Blog>, SimpleDeletable {

    /**
     * w肵uOɎw肵Lo^܂B
     *
     * @param blogId uO ID
     * @param entryId uOL ID ibZ[W IDj
     */
    void registerBlogEntry(int blogId, int entryId);

    /**
     * w肵LɃRgo^܂B
     *
     * @param entryId uOL ID ibZ[W IDj
     * @param commentId Rg ID
     */
    void registerComment(int entryId, int commentId);

    /**
     * R[hw肵ăuO擾܂B
     *
     * @param code R[h
     * @return uOAȂ <code>null</code>
     */
    Blog findByCode(String code);

    /**
     * w肵L҂̃uOXg擾܂B
     *
     * @param ownerId L҂̃[U ID
     * @return uOXg
     */
    List<Blog> findByOwnerId(int ownerId);

    /**
     * [UɌJĂuO擾܂BԂl̃Xg͓o^̍~B
     *
     * @return uOXg
     */
    List<Blog> findPublicBlogs();

    /**
     * [UɌJĂuO擾܂B
     *
     * @param max ő匏
     * @return uOXg
     */
    List<Blog> findPublicBlogsRandomly(int max);

    /**
     * @require uOLĂȂ
     * @ensure uOɊ֘AIuWFNg폜
     */
    @Override
    void delete(int blogId);

    /**
     * uOuOL̐擾܂B
     *
     * @param blogId uO ID
     * @return uOL
     */
    int countBlogEntry(int blogId);

    /**
     * uOLRg擾܂B
     *
     * @param blogEntryId uOL ID
     * @return Rg
     */
    int countComment(int blogEntryId);

    /**
     * w肵͈͂̃uOL擾܂BLԍ͂On܂鐮ŁAID ̍~ɂȂ܂B
     *
     * @param blogId uO ID
     * @param no Jn_ƂȂLԍ
     * @param num 
     * @return uOLXg
     */
    List<BlogEntry> findBlogEntries(int blogId, int no, int num);

    /**
     * w肵uOL̃Rg擾܂B
     *
     * @param entryId uOL ID ibZ[W IDj
     * @return RgXg
     */
    List<Comment> findComments(int entryId);

    /**
     * w肵uOL폜܂BuOLɕtRg폜܂B
     *
     * @param entryId uOL ID
     */
    void deleteBlogEntry(int entryId);
}
