package org.unitedfront2.util;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.Account.Status;

public class PropertyUtilsTest {

    @Test
    public void testGetType() {
        Account account = new Account();
        Assert.assertEquals(Integer.class, PropertyUtils.getType(account, "id"));
        Assert.assertEquals(String.class, PropertyUtils.getType(account, "mailAddr"));
        Assert.assertEquals(Status.class, PropertyUtils.getType(account, "status"));
    }

    @Test
    public void testIsEnumTrue() {
        Account account = new Account();
        Assert.assertTrue(PropertyUtils.isEnum(account, "status"));
    }

    @Test
    public void testIsEnumFalse() {
        Account account = new Account();
        Assert.assertFalse(PropertyUtils.isEnum(account, "id"));
    }
}
