package org.unitedfront2.test;

import java.lang.reflect.Method;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.SimpleTableModule;
import org.unitedfront2.util.PropertyUtils;

/**
 * <code>exist</code>, <code>find</code>, <code>get</code>,
 * <code>prototype</code> \bh̃eXgP[XA{@link SimpleTableModule}
 * p̒ۃeXgP[XłB
 *
 * @author kurokkie
 *
 * @param <D> hC
 */
public abstract class TableModuleTestCaseSupport<D extends Domain>
    extends TransactionalTestCaseWithInitialData {

    /** ID ̃vpeB̃ftHg (id) */
    public static final String DEFAULT_PRIMARY_KEY_PROPERTY_NAME = "id";

    @Test
    public void testFindFound() throws Exception {
        D expected = createDomain();
        store(expected);
        D actual = getTableModule().find((Integer)
            PropertyUtils.getProperty(expected, getPrimaryKeyPropertyName()));
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testFindNotFound() {
        D actual = getTableModule().find(-1);
        Assert.assertNull(actual);
    }

    @Test
    public void testGetFound() throws Exception {
        D expected = createDomain();
        store(expected);
        D actual = getTableModule().get((Integer)
            PropertyUtils.getProperty(expected, getPrimaryKeyPropertyName()));
        Assert.assertEquals(expected, actual);
    }

    @Test(expected = IllegalArgumentException.class)
    public void testGetNotFound() {
        getTableModule().get(-1);
    }

    @Test
    public void testExistExist() throws Exception {
        D expected = createDomain();
        store(expected);
        Assert.assertTrue(getTableModule().exist((Integer)
            PropertyUtils.getProperty(expected, getPrimaryKeyPropertyName())));
    }

    @Test
    public void testExistNotExist() {
        Assert.assertFalse(getTableModule().exist(-1));
    }

    /**
     * L[ƂȂvpeB擾܂BftHgł
     * {@link #DEFAULT_PRIMARY_KEY_PROPERTY_NAME} Ԃ܂BKvɉăI[o[Ch
     * B
     *
     * @return L[ƂȂvpeB
     */
    protected String getPrimaryKeyPropertyName() {
        return DEFAULT_PRIMARY_KEY_PROPERTY_NAME;
    }

    /**
     * eXgf[^ݒς݂̃hCIuWFNg𐶐܂B
     *
     * @return eXgf[^ݒς݂̃hCIuWFNg
     */
    protected abstract D createDomain();

    /**
     * eXgΏۂƂȂ {@link SimpleTableModule} 擾܂B
     *
     * @return {@link SimpleTableModule}
     */
    protected abstract SimpleTableModule<D> getTableModule();

    /**
     * f[^ANZXIuWFNg擾܂BhC̃pbP[Wł́ADomains#getSimpleDao() 
     * gƂł܂B
     *
     * @return {@link SimpleFindable}
     */
    protected abstract SimpleFindable<D> getSimpleDao();

    protected void store(D domain) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("The domain is '" + domain + "'");
        }
        Method save = domain.getClass().getMethod("store");
        if (logger.isInfoEnabled()) {
            logger.info("Call save method.");
        }
        save.invoke(domain);
    }
}
