package org.unitedfront2.domain.communication;

import java.util.Locale;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.domain.accesscontrol.AuthorOnly;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.domain.communication.Thread.Status;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class ThreadTest extends TransactionalTestCaseWithInitialData {

    @Test
    public void testPost() {
        Thread t = createThread();
        t.store();
        Message e = createEntry();
        t.post(e);
        t.retrieveEntries(0, 1);
        Assert.assertSame(1, t.getEntries().size());
        Assert.assertEquals(e, t.getEntries().get(0));
        Assert.assertEquals(t.getReadAccessControl(), e.getReadAccessControl());
        Assert.assertSame(AuthorOnly.class, e.getWriteAccessControl().getType());
    }

    private Thread createThread() {
        return domainFactory.prototype(new Thread(createOverview(),
                Status.AVAILABLE, simpleUser1.getId(),
                domainFactory.prototype(UserOnly.class),
                domainFactory.prototype(OwnerOnly.class),
                domainFactory.prototype(OwnerOnly.class)));
    }

    private Message createOverview() {
        Message o = domainFactory.prototype(Message.class);
        o.setSubject("eXgXbh", Locale.JAPANESE);
        o.setBody("̓eXgXbhłB", Locale.JAPANESE);
        return o;
    }

    private Message createEntry() {
        Message e = domainFactory.prototype(Message.class);
        e.setAuthorId(simpleUser2.getId());
        e.setSubject("eXgL", Locale.JAPANESE);
        e.setBody("̓eXgLłB", Locale.JAPANESE);
        return e;
    }
}
