package org.unitedfront2.dao;

import java.util.Map;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.EmailForwarding;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class EmailForwardingDaoTest extends
        TransactionalTestCaseWithInitialData {

    @Autowired private EmailForwardingDao emailForwardingDao;

    @Test
    public void testRegister() {
        emailForwardingDao.register(simpleUser1.getId());
        Assert.assertNotNull(emailForwardingDao.find(simpleUser1.getId()));
    }

    @Test
    public void testFind() {
        emailForwardingDao.register(simpleUser1.getId());
        Map<EmailForwarding, Boolean> map = emailForwardingDao.find(simpleUser1.getId());
        Assert.assertNotNull(map);
        Assert.assertTrue(map.get(EmailForwarding.MAIL));
        Assert.assertFalse(map.get(EmailForwarding.BLOG_COMMENT));
    }

    @Test
    public void testFindArgsForwarding() {
        emailForwardingDao.register(simpleUser1.getId());
        Assert.assertTrue(emailForwardingDao.find(simpleUser1.getId(), EmailForwarding.MAIL));
        Assert.assertFalse(emailForwardingDao.find(simpleUser1.getId(), EmailForwarding.BLOG_COMMENT));
    }

    @Test
    public void testUpdate() {
        emailForwardingDao.register(simpleUser1.getId());
        Map<EmailForwarding, Boolean> map = emailForwardingDao.find(simpleUser1.getId());
        map.put(EmailForwarding.MAIL, false);
        map.put(EmailForwarding.BLOG_COMMENT, true);
        emailForwardingDao.update(simpleUser1.getId(), map);
        Map<EmailForwarding, Boolean> found = emailForwardingDao.find(simpleUser1.getId());
        Assert.assertFalse(found.get(EmailForwarding.MAIL));
        Assert.assertTrue(found.get(EmailForwarding.BLOG_COMMENT));
    }
}
