package org.unitedfront2.dao;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.communication.Comment;
import org.unitedfront2.test.DaoTestCaseSupport;

public class CommentDaoTest extends DaoTestCaseSupport<Comment> {

    @Autowired
    private CommentDao commentDao;

    @Override
    protected Comment createTestDomain() {
        Comment comment = new Comment();
        comment.setCommenterId(simpleUser1.getId());
        comment.setText("̓Rg̃eXgłB");
        comment.setLastUpdateDate(commentDao.getCurrentDate());
        return comment;
    }

    @Override
    protected void editTestDomain(Comment comment) {
        comment.setText("new_" + comment.getText());
    }

    @Override
    protected Object getDao() {
        return commentDao;
    }
}
