package org.unitedfront2.web.handler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Repository;
import org.springframework.ui.context.Theme;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.unitedfront2.web.WebUtils;

/**
 * NCAg̎gpfUCɉăfUC؂ւC^[Zv^łB
 *
 * @author kurokkie
 * @see org.springframework.web.servlet.theme.ThemeChangeInterceptor
 */
@Repository(value = "themeChangeInterceptor")
public class ThemeChangeInterceptor extends
        org.springframework.web.servlet.theme.ThemeChangeInterceptor {

    /**
     * NGXgɃP[ݒ肵܂B
     *
     * @param request HTTP NGXg
     * @param response HTTP X|X
     * @param handler nh
     * @return ȍ~̃C^[Zv^ĂяoȂ true AłȂ false
     * @throws ServletException T[ubgO
     */
    @Override
    public boolean preHandle(HttpServletRequest request,
        HttpServletResponse response, Object handler)
        throws ServletException {

        boolean result = super.preHandle(request, response, handler);
        Theme theme = RequestContextUtils.getTheme(request);
        request.setAttribute(WebUtils.THEME_PARAM_NAME, theme.getName());
        return result;
    }
}
