package org.unitedfront2.web.controller.profile;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.BadRequestException;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * FB߂ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profile.friendRemoveAction")
public class FriendRemoveAction extends AbstractAction {

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    /**
     * FB߂܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException <code>userCode</code> p[^NGXgĂ
     *   Ȃ
     * @throws BadRequestException NGXg[UFBłȂ
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws PageNotFoundException, BadRequestException {
        String userCode = context.getRequestParameters().get("userCode");
        if (StringUtils.isBlank(userCode)) {
            String message = "The parameter 'userCode' must be requested.";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }
        User user = WebUtils.getUser(context);
        try {
            removeFriend(user.getId(), userCode);
        } catch (UserNotFoundException e) {
            throw new PageNotFoundException(context, this, e);
        } catch (UserNotFriendException e) {
            throw new BadRequestException(context, this, e);
        }
        context.getFlowScope().put("userCode", userCode);
        return success();
    }

    private void removeFriend(int userId, String friendCode)
        throws UserNotFoundException, UserNotFriendException {
        User friend = simpleUserTable.findByCode(friendCode);
        if (friend == null) {
            String message = "The user [UserCode='" + friendCode
                + "'] not found.";
            logger.warn(message);
            throw new UserNotFoundException(message);
        }

        Profile profile = profileTable.get(userId);
        if (!profile.isFriend(friend.getId())) {
            String message = "The friend [UserCode='" + friendCode
                + "'] is not a friend of the user [UserID='" + userId + "'].";
            logger.warn(message);
            throw new UserNotFriendException(message);
        }
        profile.removeFriend(friend.getId());
    }
}
