package org.unitedfront2.web.controller.profile;

import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Footmark;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;

/**
 * ՃEBWFbg̃r[vyA[NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profile.footmarkWidgetPreparer")
public class FootmarkWidgetPreparer implements ViewPreparer {

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    @Override
    public void execute(TilesRequestContext tilesContext,
            AttributeContext attributeContext) throws PreparerException {

        User user = WebUtils.findUser(tilesContext);
        if (user == null) {
            return;
        }
        Profile profile = profileTable.get(user.getId());
        profile.retrieveFootmarks();
        Footmark.retrieveProfiles(profile.getFootmarks());
        attributeContext.putAttribute("footmarks",
            new Attribute(profile.getFootmarks()));
    }
}
