package org.unitedfront2.web.controller.error;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.mail.CreateAction;

/**
 * G[̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "error.errorAction")
public class ErrorAction extends MultiAction {

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    /**
     * [MTut[p̏s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        Mail mail = domainFactory.prototype(Mail.class);
        SimpleUser to = simpleUserTable.getByCode(WebUtils.ADMIN_USER_CODE);
        mail.setToId(to.getId());
        mail.setTo(to);
        mail.setSubject(WebUtils.getMessage("error.Error.mailPrefix", null,
                context));

        context.getFlowScope().put(CreateAction.MAIL_PARAM_NAME, mail);
        context.getFlowScope().put(CreateAction.IGNORE_EMAIL_FAILURE_PARAM_NAME,
                true);
        context.getFlowScope().put(CreateAction.UNMODIFIABLE_TO_PARAM_NAME,
                mail.getTo());
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "error.Error");
        context.getFlowScope().put(
                SubflowUtils.PAGE_DESCRIPTION_CODE_PARAM_NAME,
                "error.Error.body");
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "error.Error.submit");
        return success();
    }
}
