package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.util.HtmlUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.AccessDeniedException;
import org.unitedfront2.web.flow.PageNotFoundException;
import org.unitedfront2.web.handler.TitleInterceptor;

/**
 * uO{ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.viewAction")
public class ViewAction extends AbstractAction {

    /** Py[Wɕ\uOLiTj */
    public static final int DISPLAY_COUNT = 5;

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    /**
     * w肵R[huO\܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException uO݂Ȃ
     * @throws AccessDeniedException {Ȃ
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws PageNotFoundException, AccessDeniedException {
        Blog blog = Utils.findAndReadAccessByCode(context, this, blogTable,
                "code");

        // \͈͂̌
        int page = context.getRequestParameters().getInteger("page", 0);
        blog.retrieveEntries(page * DISPLAY_COUNT, DISPLAY_COUNT);
        blog.retrieveCount();
        if (blog.getEntries().size() == 0 && blog.getCount() > 0) {
            String message = "The page " + page + " not found.";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }

        // Rg̕
        for (BlogEntry entry : blog.getEntries()) {
            entry.retrieveCommentCount();
        }

        // L҂̕
        blog.retrieveOwner();
        blog.getOwner().retrieveProfile();

        // 
        User user = WebUtils.findUser(context);
        if (user != null) {
            blog.getOwner().getProfile().footmark(user.getId());
        }

        context.getRequestScope().put(
                TitleInterceptor.TITLE_CODE_PARAM_NAME, "blog.View.title");
        context.getRequestScope().put(
                TitleInterceptor.TITLE_ARGS_PARAM_NAME,
                new Object[] {
                        HtmlUtils.htmlEscape(blog.getOverview()
                                .getSubject(WebUtils.getLocale(context))),
                });

        context.getRequestScope().put("blog", blog);
        context.getRequestScope().put("displayCount", DISPLAY_COUNT);
        context.getRequestScope().put("_feedUrl", "/blog/" + blog.getCode()
                + "/index.xml");
        return success();
    }
}
