package org.unitedfront2.validation;

import java.util.Collection;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.validator.GenericValidator;

/**
 * ؂x郆[eBeB\bh^NXłB
 *
 * @author kurokkie
 *
 */
public final class Validate {

    /**
     * l̕w肵͈͓ł邩؂܂B
     *
     * @param value l
     * @param min ŏ
     * @param max ő啶
     * @throws ValidationException l̕w肵͈͊O
     * @see #notNull(Object)
     */
    public static void lengthInRange(String value, int min, int max)
        throws ValidationException {
        if (value.length() < min || value.length() > max) {
            throw new ValidationException(
                "validation.Validate.lengthInRange.error",
                new Object[] {value.length(), min, max},
                "The value '" + value + "' length is not in range. [min: '"
                + min + "', max: '" + max + "']");
        }
    }

    /**
     * l[AhXł邩؂܂B
     *
     * @param value l
     * @throws ValidationException l[AhXłȂ
     * @see GenericValidator#isEmail(String)
     */
    public static void mailAddr(String value)
        throws ValidationException {
        if (!GenericValidator.isEmail(value)) {
            throw new ValidationException("validation.Validate.mailAddr.error",
                null, "The value '" + value + "' is not mail address.");
        }
    }

    /**
     * lK\Ɉv邩؂܂B
     *
     * @param value l
     * @param regex K\
     * @throws ValidationException lK\ɈvȂ
     * @see #notNull(Object)
     */
    public static void match(String value, String regex)
        throws ValidationException {
        if (!value.matches(regex)) {
            throw new ValidationException("validation.Validate.match.error",
                null, "The value '" + value + "' is not valid regex. [regex: '"
                + regex + "']");
        }
    }

    /**
     * l̕w肵ő啶ȉł邩؂܂B
     *
     * @param value l
     * @param max ő啶
     * @throws ValidationException l̕ő啶傫
     * @see #notNull(Object)
     */
    public static void maxLength(String value, int max)
        throws ValidationException {
        if (value.length() > max) {
            throw new ValidationException("validation.Validate.maxLength.error",
                new Object[] {value.length(), max}, "The value '" + value
                + "' is not in range. [max: '" + max + "'].");
        }
    }

    /**
     * l̗[ɋ󔒂܂łȂ؂܂Bł̋󔒂ɂ́Ap󔒁ASp󔒂܂܂܂B
     *
     * @param value l
     * @throws ValidationException l̗[ɋ󔒂܂ł
     * @see #notNull(Object)
     */
    public static void notAroundSpaces(String value)
        throws ValidationException {
        if (value == null || value.length() == 0) {
            return;
        }
        if (value.charAt(0) == ' ' || value.endsWith(" ")
            || value.charAt(0) == '@' || value.endsWith("@")) {
            throw new ValidationException(
                "validation.Validate.notAroundSpaces.error", null,
                "The value '" + value + "' has spaces in around.");
        }
    }

    /**
     * lłȂ؂܂B
     *
     * @param value l
     * @throws ValidationException l
     * @see StringUtils#isEmpty(String)
     */
    public static void notEmpty(String value) throws ValidationException {
        if (StringUtils.isEmpty(value)) {
            throw new ValidationException("validation.Validate.notEmpty.error",
                null, "The value is empty.");
        }
    }

    /**
     * z񂪋łȂ؂܂B
     *
     * @param value z
     * @throws ValidationException z񂪋
     */
    public static void notEmpty(Object[] value) throws ValidationException {
        if (value.length == 0) {
            throw new ValidationException("validation.Validate.notEmpty.error",
                null, "The array is empty");
        }
    }

    /**
     * RNVłȂ؂܂B
     *
     * @param value RNV
     * @throws ValidationException z񂪋
     */
    public static void notEmpty(Collection< ? extends Object> value)
        throws ValidationException {
        if (value.isEmpty()) {
            throw new ValidationException("validation.Validate.notEmpty.error",
                null, "The collection is empty");
        }
    }

    /**
     * luNłȂ؂܂BpASpAsA^û݂ō\镶̓uNłB
     *
     * @param value l
     * @throws ValidationException luN
     * @see StringUtils#isEmpty(String)
     */
    public static void notBlank(String value) throws ValidationException {
        if (StringUtils.isBlank(value)) {
            throw new ValidationException("validation.Validate.notBlank.error",
                null, "The value is blank.");
        }
    }

    /**
     * l <code>null</code> łȂ؂܂B
     *
     * @param value l
     * @throws ValidationException l null
     */
    public static void notNull(Object value) throws ValidationException {
        if (value == null) {
            throw new ValidationException("validation.Validate.notNull.error",
                null, "The value is null.");
        }
    }

    /**
     * llł邱Ƃ؂܂B
     *
     * @param value l
     * @throws ValidationException llłȂ
     */
    public static void number(String value) throws ValidationException {
        if (!NumberUtils.isNumber(value)) {
            throw new ValidationException("validation.Validate.number.error",
                null, "The value is not number.");
        }
    }

    private Validate() {
        super();
    }
}
