package org.unitedfront2.dao;

import java.util.List;

import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.communication.Profile;

/**
 * vtB[f[^ւ̃ANZXC^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface ProfileDao extends Registerable<Profile>,
    SimpleFindable<Profile>, Updatable<Profile>, Dao {

    @Override
    void register(Profile profile);

    /**
     * L҂̃[UR[hvtB[擾܂B
     *
     * @param ownerCode L҂̃[UR[h
     * @return vtB[
     * @ensure ${this.find(ownerId)} equals ${return}
     */
    Profile findByOwnerCode(String ownerCode);

    /**
     * QƃANZX擾܂B
     *
     * @param ownerId L ID
     * @return QƃANZXAȂ <code>null</code>
     * @ensure ${this.find(ownerId).readAccessControl} equals ${return}
     */
    AccessControl findReadAccessControl(int ownerId);

    /**
     * ŜɌJĂvtB[̏L҃Xg_Ɏ擾܂B
     *
     * @return vtB[L҃Xg
     * @ensure SẴ[ŨvtB[̎Qƌ
     * {@link org.unitedfront2.domain.accesscontrol.Public}
     */
    List<SimpleUser> findPublicProfileOwnersRandomly();

    /**
     * ŜɌJĂvtB[̏L҃Xgw萔_Ɏ擾܂B
     *
     * @param max ő匏
     * @return vtB[L҃Xg
     * @ensure ${return.size} <= ${max}
     * @ensure SẴ[ŨvtB[̎Qƌ
     * {@link org.unitedfront2.domain.accesscontrol.Public}
     */
    List<SimpleUser> findPublicProfileOwnersRandomly(int max);

    @Override
    void update(Profile profile);
}
