package org.unitedfront2.domain.communication;

import java.util.Set;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class ProfileTest extends TransactionalTestCaseWithInitialData {

    private Profile profile;

    @Autowired private ProfileTable profileTable;

    @Override
    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        profileTable.install(simpleUser1.getId());
        profileTable.install(simpleUser2.getId());
        profileTable.install(simpleUser3.getId());
        profile = profileTable.get(simpleUser1.getId());
    }

    @Test
    public void testFootmarkՂ() {
        profile.footmark(simpleUser2.getId());
        profile.retrieveFootmarks();
        Assert.assertEquals(1, profile.getFootmarks().size());
    }

    @Test
    public void testFootmarkg̑Ղ͂Ȃ() {
        profile.footmark(simpleUser1.getId());
        profile.retrieveFootmarks();
        Assert.assertEquals(0, profile.getFootmarks().size());
    }
    @Test
    public void testRetrieveFootmarkԓ̑Ղ̓}[W() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.getReadAccessControl().changeTo(UserOnly.class);
        profile.getReadAccessControl().store();
        profile.footmark(simpleUser2.getId());
        profile.footmark(simpleUser3.getId());
        profile.footmark(simpleUser2.getId());
        profile.footmark(simpleUser1.getId());
        profile.footmark(simpleUser2.getId());
        profile.footmark(simpleUser3.getId());
        profile.retrieveFootmarks();
        Assert.assertEquals(2, profile.getFootmarks().size());
        Assert.assertTrue(simpleUser3.identify(profile.getFootmarks().get(0).getUser()));
        Assert.assertTrue(simpleUser2.identify(profile.getFootmarks().get(1).getUser()));
    }

    @Test
    public void testRetrieveFootmarkԊȎՂ̓}[WȂ() throws AccessDeniedException, InterruptedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.getReadAccessControl().changeTo(UserOnly.class);
        profile.getReadAccessControl().store();
        profile.footmark(simpleUser2.getId());
        java.lang.Thread.sleep(1000);
        profile.footmark(simpleUser3.getId());
        java.lang.Thread.sleep(1000);
        profile.footmark(simpleUser2.getId());
        profile.setFootmarkMergeSeconds(1);
        profile.retrieveFootmarks();
        Assert.assertEquals(3, profile.getFootmarks().size());
        Assert.assertTrue(simpleUser2.identify(profile.getFootmarks().get(0).getUser()));
        Assert.assertTrue(simpleUser3.identify(profile.getFootmarks().get(1).getUser()));
        Assert.assertTrue(simpleUser2.identify(profile.getFootmarks().get(2).getUser()));
    }

    @Test
    public void testExistFriendSubscriptionTrue() {
        profile.subscribe(simpleUser2.getId());
        Assert.assertTrue(profile.existFriendSubscription(simpleUser2.getId()));
    }

    @Test
    public void testExistFriendSubscriptionFalse() {
        Assert.assertFalse(profile.existFriendSubscription(simpleUser2.getId()));
    }

    @Test
    public void testAllowFriendSubscription() {
        profile.subscribe(simpleUser2.getId());

        Assert.assertTrue(profile.existFriendSubscription(simpleUser2.getId()));
        profile.allowFriendSubscription(simpleUser2.getId());
        Assert.assertFalse(profile.existFriendSubscription(simpleUser2.getId()));
        Assert.assertTrue(profile.isFriend(simpleUser2.getId()));
    }

    @Test
    public void testDenyFriendSubscription() {
        profile.subscribe(simpleUser2.getId());

        Assert.assertTrue(profile.existFriendSubscription(simpleUser2.getId()));
        profile.denyFriendSubscription(simpleUser2.getId());
        Assert.assertFalse(profile.existFriendSubscription(simpleUser2.getId()));
        Assert.assertFalse(profile.isFriend(simpleUser2.getId()));
    }

    @Test
    public void testRemoveFriend() {
        profile.subscribe(simpleUser2.getId());
        profile.allowFriendSubscription(simpleUser2.getId());

        Assert.assertTrue(profile.isFriend(simpleUser2.getId()));        
        profile.removeFriend(simpleUser2.getId());
        Assert.assertFalse(profile.isFriend(simpleUser2.getId()));
    }

    @Test
    public void testGetFriendsOfFriends() {
        // [UPƃ[UQFB
        profile.subscribe(simpleUser2.getId());
        profile.allowFriendSubscription(simpleUser2.getId());

        // [UQƃ[URFB
        Profile profile2 = profileTable.find(simpleUser2.getId());
        profile2.subscribe(simpleUser3.getId());
        profile2.allowFriendSubscription(simpleUser3.getId());

        Set<SimpleUser> fof = profile.getFriendsOfFriends();
        Assert.assertTrue(SimpleUser.exists(fof, simpleUser2));
        Assert.assertTrue(SimpleUser.exists(fof, simpleUser3));
    }

    @Test
    public void testRetrieveProfileOfFriends() {
        profile.retrieveFriends();
        profile.retrieveProfileOfFriends();
        for (SimpleUser u : profile.getFriends()) {
            Assert.assertNotNull(u.getProfile());
        }
    }

    @Test
    public void testRetrieveSelfIntroduction() {
        Assert.assertNull(profile.getSelfIntroduction());
        profile.retrieveSelfIntroduction();
        Assert.assertNotNull(profile.getSelfIntroduction());
    }
}
