package org.unitedfront2.domain;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.SampleDomainDao;

/**
 * TvhC̃hCfłB
 *
 * @invariant ${this.d} > 0
 * @author kurokkie
 *
 */
public class SampleDomain implements Identifiable<SampleDomain>, Storable,
    Deletable, Serializable, Domain {

    /** Ԃ̒` */
    public static enum State {

        /** p\ */
        AVAILABLE,

        /** ps\ */
        DISABLE
    }

    /** VAԍ */
    private static final long serialVersionUID = -2784958436581567548L;

    /** O */
    protected final transient Log logger = LogFactory.getLog(getClass());

    /** ID */
    private Integer id;

    /**
     * R[h
     *
     * @invariant ӂȒl
     */
    private String code;

    /** _ */
    private Double d;

    /** eLXg */
    private String text;

    /** ^Ȃ <code>true</code> AUȂ <code>false</code> */
    private Boolean bool;

    /**
     * 
     *
     * @invariant not null
     */
    private Date date;

    /**
     * 
     *
     * @invariant not null
     */
    private State state;

    /** TvhCf[^ANZXIuWFNg */
    private transient SampleDomainDao sampleDomainDao;

    public SampleDomain() {
        super();
    }

    public SampleDomain(String code, Double d, String text, Boolean bool,
            Date date, State state) {
        super();
        this.code = code;
        this.d = d;
        this.text = text;
        this.bool = bool;
        this.date = (Date) date.clone();
        this.state = state;
    }

    public SampleDomain(Integer id, String code, Double d, String text,
            Boolean bool, Date date, State state) {
        this(code, d, text, bool, date, state);
        this.id = id;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("id", id)
            .append("code", code)
            .append("d", d)
            .append("text", text)
            .append("bool", bool)
            .append("date", date)
            .append("state", state).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof SampleDomain)) {
            return false;
        }
        SampleDomain castOther = (SampleDomain) other;
        return new EqualsBuilder()
            .append(id, castOther.id)
            .append(code, castOther.code)
            .append(d, castOther.d)
            .append(text, castOther.text)
            .append(bool, castOther.bool)
            .append(date, castOther.date)
            .append(state, castOther.state).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(id)
            .append(code)
            .append(d)
            .append(text)
            .append(bool)
            .append(date)
            .append(state).toHashCode();
    }

    @Override
    public boolean identify(SampleDomain other) {
        if (id == null) {
            return false;
        }
        return id.equals(other.getId());
    }

    @Override
    public void store() throws DuplicateSampleDomainCodeException {
        if (id == null) {
            if (sampleDomainDao.findByCode(code) != null) {
                String message = "The code '" + code + "' already exists.";
                logger.warn(message);
                throw new DuplicateSampleDomainCodeException(message);
            }
            sampleDomainDao.register(this);
        } else {
            SampleDomain found = sampleDomainDao.findByCode(code);
            if (found != null && !identify(found)) {
                String message = "The code '" + code + "' already exists.";
                logger.warn(message);
                throw new DuplicateSampleDomainCodeException(message);
            }
            sampleDomainDao.update(this);
        }
    }

    @Override
    public void delete() {
        sampleDomainDao.delete(id);
    }

    /**
     * @return eLXgƕ_̊|Ž
     */
    public double multipleTextLengthAndD() {
        int textLength;
        if (text == null) {
            textLength = 0;
        } else {
            textLength = text.length();
        }
        return textLength * d;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Double getD() {
        return d;
    }

    public void setD(Double d) {
        this.d = d;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Boolean getBool() {
        return bool;
    }

    public void setBool(Boolean bool) {
        this.bool = bool;
    }

    public Date getDate() {
        if (date == null) {
            return null;
        } else {
            return (Date) date.clone();
        }
    }

    public void setDate(Date date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = (Date) date.clone();
        }
    }

    public State getState() {
        return state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setSampleDomainDao(SampleDomainDao sampleDomainDao) {
        this.sampleDomainDao = sampleDomainDao;
    }
}
