package org.unitedfront2.dao;

import junit.framework.Assert;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageCodeUsedByOtherException;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class SelfIntroductionDaoTest extends
        TransactionalTestCaseWithInitialData {

    @Autowired private SelfIntroductionDao selfIntroductionDao;

    @Test
    public void testRegister() throws MessageCodeUsedByOtherException {
        Message message = domainFactory.prototype(new Message(null, null,
                simpleUser1.getId(), simpleUser1.getId(),
                domainFactory.prototype(Public.class),
                domainFactory.prototype(OwnerOnly.class)));
        message.store();

        selfIntroductionDao.register(simpleUser1.getId(), message.getId());
        Assert.assertTrue(message.getId() == selfIntroductionDao.findMessageId(simpleUser1.getId()));
    }

    @Test
    public void testFindMessageId() throws MessageCodeUsedByOtherException {
        Message message = domainFactory.prototype(new Message(null, null,
                simpleUser1.getId(), simpleUser1.getId(),
                domainFactory.prototype(Public.class),
                domainFactory.prototype(OwnerOnly.class)));
        message.store();
        selfIntroductionDao.register(simpleUser1.getId(), message.getId());

        Assert.assertTrue(message.getId() == selfIntroductionDao.findMessageId(simpleUser1.getId()));
    }
}
