package org.unitedfront2.dao;

import java.util.Set;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.User;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class FriendSubscriptionDaoTest extends TransactionalTestCaseWithInitialData {

    @Autowired private FriendSubscriptionDao friendSubscriptionDao;

    @Autowired private SimpleUserDao simpleUserDao;

    @Test
    public void testFind() {
        friendSubscriptionDao.register(simpleUser1.getId(), simpleUser2.getId());

        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        User friend = friendSubscriptionDao.find(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNotNull(friend);
        Assert.assertEquals(simpleUser2, friend);
    }

    @Test
    public void testFindȂ() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        User friend = friendSubscriptionDao.find(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNull(friend);
    }

    @Test
    public void testFind݂Ȃ[UȂ() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        User friend = friendSubscriptionDao.find(simpleUser1.getId(), -1);
        Assert.assertNull(friend);
    }

    @Test
    public void testFindByFromId() {
        friendSubscriptionDao.register(simpleUser1.getId(), simpleUser2.getId());
        friendSubscriptionDao.register(simpleUser1.getId(), simpleUser3.getId());
        Set<SimpleUser> friends = friendSubscriptionDao.findByFromId(simpleUser1.getId());
        Assert.assertEquals(2, friends.size());
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser2));
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser3));
    }

    @Test
    public void testFindByToId() {
        friendSubscriptionDao.register(simpleUser2.getId(), simpleUser1.getId());
        friendSubscriptionDao.register(simpleUser3.getId(), simpleUser1.getId());
        Set<SimpleUser> friends = friendSubscriptionDao.findByToId(simpleUser1.getId());
        Assert.assertEquals(2, friends.size());
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser2));
        Assert.assertTrue(SimpleUser.exists(friends, simpleUser3));
    }

    @Test
    public void testRegister() {
        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        Assert.assertTrue(simpleUser1.getId().intValue() != simpleUser2.getId().intValue());
        Assert.assertNull(friendSubscriptionDao.find(simpleUser1.getId(), simpleUser2.getId()));
        friendSubscriptionDao.register(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNotNull(friendSubscriptionDao.find(simpleUser1.getId(), simpleUser2.getId()));
    }

    @Test
    public void testDelete() {
        friendSubscriptionDao.register(simpleUser1.getId(), simpleUser2.getId());

        Assert.assertNotNull(simpleUserDao.find(simpleUser1.getId()));
        Assert.assertNotNull(simpleUserDao.find(simpleUser2.getId()));
        Assert.assertNotNull(friendSubscriptionDao.find(simpleUser1.getId(), simpleUser2.getId()));
        friendSubscriptionDao.delete(simpleUser1.getId(), simpleUser2.getId());
        Assert.assertNull(friendSubscriptionDao.find(simpleUser1.getId(), simpleUser2.getId()));
    }
}
