<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>

<div>
  <h2><spring:message code="profile.View" arguments="${profile.owner.name}"/></h2>

  <!-- Active Status -->
  <div>
    <c:choose>
      <c:when test="${profile.owner.active}">
    <span class="active"><spring:message code="circle"/></span>&nbsp;
    <spring:message code="profile.View.active.active" arguments="${profile.owner.name}"/>
      </c:when>
      <c:otherwise>
    <span class="sleep"><spring:message code="circle"/></span>&nbsp;
    <spring:message code="profile.View.active.notActive" arguments="${profile.owner.name}"/>
      </c:otherwise>
    </c:choose>
  </div>

  <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN">
    <uf2:notIdentity o1="${profile.owner}" o2="${_user}">
      <!-- Mail Send -->
      <div class="align-right">
        <a href="<c:url value="/mail/create.html?code=${profile.owner.code}"/>"><spring:message code="profile.View.mailSend"/></a>
      </div>
    </uf2:notIdentity>
  </security:authorize>

  <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN">
  <uf2:notIdentity o1="${profile.owner}" o2="${_user}">
    <!-- Friend Status -->
    <div class="margin-top">
      <uf2:userExists user="${_user}" users="${profile.subscriptingUsers}">
        <div class="align-right">
          <spring:message code="profile.View.FriendSubscribe.description.done"/>
        </div>
      </uf2:userExists>
      <uf2:userNotExists user="${_user}" users="${profile.subscriptingUsers}">
        <uf2:userNotExists user="${_user}" users="${profile.friends}">
          <form action="<c:url value="/profile/friendSubscribe.html"/>" method="post" class="align-right">
            <input type="hidden" name="userCode" value="${profile.owner.code}"/>
            <input type="submit" name="" value="<spring:message code="profile.View.friend.subscribe"/>"/>
          </form>
        </uf2:userNotExists>
      </uf2:userNotExists>
      <uf2:userExists user="${_user}" users="${profile.friends}">
        <form action="<c:url value="/profile/friendRemove.html"/>" method="post" onsubmit="return confirm('<spring:escapeBody javaScriptEscape="true"><spring:message code="profile.FriendRemove.confirm" arguments="${profile.owner.name}"/></spring:escapeBody>')" class="align-right">
          <input type="hidden" name="userCode" value="${profile.owner.code}"/>
          <input type="submit" name="" value="<spring:message code="profile.FriendRemove.link"/>"/>
        </form>
      </uf2:userExists>
    </div>
  </uf2:notIdentity>
  </security:authorize>

  <c:if test="${!profile.selfIntroduction.emptyEntry}">
  <!-- Self-Introduction -->
  <div>
    <h3><spring:message code="profile.View.selfIntroduction.title"/><c:if test="${not empty profile.selfIntroduction.requiredEntry.subject}"> - <uf2:messageSubject message="${profile.selfIntroduction}"/></c:if></h3>
    <div class="margin"><uf2:messageBody message="${profile.selfIntroduction}"/></div>
  </div>
  </c:if>
  <uf2:identity o1="${profile.owner}" o2="${_user}">
  <div class="align-right">
    <a href="<c:url value="/profile/selfIntroductionUpdate.html"/>"><spring:message code="profile.View.selfIntroduction.editLink"/></a>
  </div>
  </uf2:identity>

  <c:if test="${not empty profile.blogs}">
  <!-- Blog -->
  <div>
    <h3><spring:message code="blog"/></h3>
    <c:forEach var="blog" items="${profile.blogs}">
    <uf2:canRead resource="${blog}" userId="${_user.id}">
    <div class="indent">
      <h4><a href="<c:url value="/blog/${blog.code}/index.html"/>"><uf2:messageSubject message="${blog.overview}"/></a></h4>
      <p><uf2:messageBody message="${blog.overview}"/></p>
      <c:if test="${not empty blog.entries}">
      <table class="indent">
        <c:forEach var="entry" items="${blog.entries}">
        <tr>
          <td><uf2:formatDate date="${entry.entry.registrationDate}"/></td>
          <td><a href="<c:url value="/blog/${blog.code}/entry-${entry.code}.html"/>"><uf2:messageSubject message="${entry.entry}"/></a></td>
        </tr>
        </c:forEach>
      </table>
      </c:if>
    </div>
    </uf2:canRead>
    </c:forEach>
  </div>
  </c:if>
  <uf2:identity o1="${profile.owner}" o2="${_user}">
  <div class="align-right">
    <a href="<c:url value="/blog/create.html"/>"><spring:message code="profile.View.blog.formLink"/></a>
  </div>
  </uf2:identity>

  <uf2:identity o1="${profile.owner}" o2="${_user}">
  <c:if test="${not empty profile.subscriptingUsers}">
  <!-- Friend Subscriptions -->
  <div>
    <h3><spring:message code="profile.View.friendSubscription"/></h3>
    <p><spring:message code="profile.View.friendSubscription.body"/></p>
    <table>
      <tr>
        <th><spring:message code="user"/></th>
        <th><spring:message code="action"/></th>
      </tr>
      <c:forEach var="user" items="${profile.subscriptingUsers}">
      <tr>
        <td><uf2:user user="${user}"/></td>
        <td>
          <form action="<c:url value="/profile/friendAllow.html"/>" method="post" class="float-left">
            <input type="hidden" name="userCode" value="${user.code}"/>
            <input type="submit" name="" value="<spring:message code="profile.View.friendSubscription.allow"/>"/>
          </form>
          <form action="<c:url value="/profile/friendDeny.html"/>" method="post" class="float-left">
            <input type="hidden" name="userCode" value="${user.code}"/>
            <input type="submit" name="" value="<spring:message code="profile.View.friendSubscription.deny"/>"/>
          </form>
          <div class="float-clear"></div>
        </td>
      </tr>
      </c:forEach>
    </table>
  </div>
  </c:if>
  </uf2:identity>

  <c:if test="${not empty profile.friends}">
  <!-- Friends -->
  <div>
    <h3><spring:message code="friend"/></h3>
    <div class="indent">
     <c:forEach var="friend" items="${profile.friends}" varStatus="status">
     <c:if test="${not status.first}">,</c:if>
     <c:choose>
       <c:when test="${friend.active}"><span class="active"><spring:message code="circle"/></span></c:when>
       <c:otherwise><span class="sleep"><spring:message code="circle"/></span></c:otherwise>
     </c:choose>
     &nbsp;<uf2:user user="${friend}"/>
     </c:forEach>
    </div>
  </div>
  </c:if>

  <uf2:identity o1="${profile.owner}" o2="${_user}">
  <c:if test="${not empty profile.footmarks}">
  <!-- Footmark -->
  <div>
    <h3><spring:message code="profile.View.footmark"/></h3>
    <p class="smaller"><spring:message code="profile.View.footmark.description"/></p>
    <uf2:pc>
    <div class="indent">
      <button class="paging" title="<spring:message code="toPrevious"/>" onClick="dijit.byId('profileFootmarkContainer').back()">&lt;</button>
      <button class="paging" title="<spring:message code="toNext"/>" onClick="dijit.byId('profileFootmarkContainer').forward()">&gt;</button>
    </div>
    </uf2:pc>
    <div id="profileFootmarkContainer" dojoType="dijit.layout.StackContainer">
      <c:forEach var="footmark" items="${profile.footmarks}" varStatus="status">
      <c:if test="${status.index % 5 == 0}"><ul id="profileFootmarkContainerPanel${status.index / 5}" class="profileFootmarkContainerPanel noneMarker" dojoType="dijit.layout.ContentPane"></c:if>
        <li id="profileFootmarkContainerItem${status.index}" class="profileFootmarkContainerItem nowrap"><uf2:formatDate date="${footmark.date}"/>&nbsp;<c:choose><c:when test="${footmark.user.active}"><span class="active"><spring:message code="circle"/></span></c:when><c:otherwise><span class="sleep"><spring:message code="circle"/></span></c:otherwise></c:choose>&nbsp;<uf2:user user="${footmark.user}"/></li>
      <c:if test="${status.index % 5 == 4 or status.last}"></ul></c:if>
      </c:forEach>
    </div>
  </div>
  </c:if>
  </uf2:identity>

  <uf2:identity o1="${profile.owner}" o2="${_user}">
  <!-- Access Control -->
  <div>
    <h3><spring:message code="accesscontrol.authority"/></h3>
    <table border="1" class="margin smaller">
      <tr>
        <th><spring:message code="accesscontrol.authority.read"/></th>
        <td>
          <spring:message code="accesscontrol.type.${profile.readAccessControl.type.simpleName}"/>
          &nbsp;<uf2:identity o1="${profile.owner}" o2="${_user}"><a href="<c:url value="/profile/accessControlUpdate.html"/>"><spring:message code="modify"/></a></uf2:identity>
        </td>
      </tr>
      <tr>
        <th><spring:message code="accesscontrol.authority.write"/></th>
        <td><spring:message code="accesscontrol.type.${profile.writeAccessControl.type.simpleName}"/></td>
      </tr>
    </table>
  </div>
  </uf2:identity>

</div>
