<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>
<div>

  <!-- Status Bar -->
  <div id="statusBar">
    <spring:message code="community"/> &gt; <spring:message code="community.type.MultiThreadCommunity"/>
  </div>

  <%@ include file="Overview.jsp" %>

  <!-- Threads -->
  <div class="margin-bottom align-center">
    <uf2:canPost community="${community}" user="${_user}">
      <a href="<c:url value="/community/${community.code}/create.html"/>"><spring:message code="community.MultiThreadView.threadCreateLink"/></a>
    </uf2:canPost>
  </div>
  <ul>
    <c:forEach var="t" items="${community.threads}">
      <li>
        <span class="smaller thin"><uf2:formatDate date="${t.lastUpdateDate}" detail="true"/></span>
        <a href="<c:url value="/community/${community.code}/${t.id}/index.html"/>"><uf2:messageSubject message="${t.overview}"/></a>
      </li>
    </c:forEach>
  </ul>

  <%@ include file="SubMenu.jsp" %>

  <%@ include file="AccessControl.jsp" %>

</div>
