package org.unitedfront2.web.tags;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

import org.unitedfront2.domain.Terminal;
import org.unitedfront2.web.handler.TerminalChangeInterceptor;

/**
 * ^OCu̎x郆[eBeBNXłB
 *
 * @author kurokkie
 *
 */
final class Utils {

    /**
     * URL 𐶐܂B
     * @param path oC̃ANZX̍ۂɂ URL ̒ɃZbVL[𖄂ߍ݂܂B
     * @param pageContext {@link PageContext}
     * @return URL
     */
    public static String createUrl(String path, PageContext pageContext) {
        StringBuffer url = new StringBuffer(pageContext.getServletContext()
                .getContextPath());
        url.append(path);
        url.append(getSessionQuery(pageContext));
        return url.toString();
    }

    private static String getSessionQuery(PageContext pageContext) {
        Object obj = pageContext.findAttribute(
            TerminalChangeInterceptor.REQUEST_KEY);
        if (obj == null) {
            return "";
        }

        Terminal t = (Terminal) obj;
        if (t != Terminal.MOBILE) {
            return "";
        }

        HttpSession session = Utils.getSession(pageContext);
        if (session == null) {
            return "";
        }

        return ";jsessionid=" + session.getId();
    }

    /**
     * {@link PageContext}  {@link HttpServletRequest} 𒊏o܂BołȂ
     * ۂ {@link IllegalArgumentException} 𔭐܂B
     *
     * @param pageContext {@link PageContext}
     * @return {@link HttpServletRequest}
     * @throws IllegalArgumentException {@link HttpServletRequest} ołȂ
     */
    public static HttpServletRequest getRequest(
            PageContext pageContext) throws IllegalArgumentException {
        ServletRequest request = pageContext.getRequest();
        if (request instanceof HttpServletRequest) {
            return (HttpServletRequest) request;
        } else {
            throw new IllegalArgumentException(
                    "HttpServletRequest not found in the page context '"
                    + pageContext + "'");
        }
    }

    /**
     * {@link PageContext}  {@link HttpSession} 𒊏o܂BJSP ŃZbV̎gp
     * ɂĂۂłÃ\bhgă^OCuZbVփANZXł܂B
     *
     * @param pageContext {@link PageContext}
     * @return ZbVA݂Ȃ <code>null</code>
     * @throws IllegalArgumentException {@link HttpServletRequest} ołȂ
     */
    public static HttpSession getSession(PageContext pageContext)
        throws IllegalArgumentException {
        HttpServletRequest request = getRequest(pageContext);
        return request.getSession(false);
    }

    private Utils() {
        super();
    }
}
