package org.unitedfront2.web.handler;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.Widget;
import org.unitedfront2.domain.WidgetTable;
import org.unitedfront2.web.WebUtils;

/**
 * ZbṼEBWFbgr[ŗpł悤ɂ܂B
 * @author kurokkie
 *
 */
@Repository(value = "widgetInterceptor")
public class WidgetInterceptor extends HandlerInterceptorAdapter {

    /** p[^̃ftHg (widget) */
    public static final String DEFAULT_PARAM_NAME = "widgets";

    /**
     * ftHg̃EBWFbgXgłB̃EBWFbg܂ł܂B
     *
     * <ul>
     *   <li>vtB[EBWFbg</li>
     * </ul>
     */
    public static final List<Widget> DEFAULT_WIDGETS;
    static {
        DEFAULT_WIDGETS = new ArrayList<Widget>();
        DEFAULT_WIDGETS.add(Widget.PUBLIC_PROFILE);
        DEFAULT_WIDGETS.add(Widget.PUBLIC_BLOGS);
        DEFAULT_WIDGETS.add(Widget.PUBLIC_COMMUNITIES);
        DEFAULT_WIDGETS.add(Widget.ACTIVE_USER_COUNT);
    }

    /** p[^ */
    private String paramName = DEFAULT_PARAM_NAME;

    /** EBWFbge[u */
    @Autowired private WidgetTable widgets;

    @Override
    public boolean preHandle(HttpServletRequest request,
            HttpServletResponse response, Object handler) throws Exception {

        HttpSession session = request.getSession(false);

        if (session == null) {
            setDefaultWidget(request);
            return true;
        }

        Account account = WebUtils.findAccount(session);

        if (account == null) {
            setDefaultWidget(request);
            return true;
        }

        List<Widget> list = WebUtils.findWidgets(session);

        if (list == null) {
            list = widgets.get(account.getId());
            WebUtils.setWidgets(session, list);
        }

        request.setAttribute(paramName, list);

        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request,
            HttpServletResponse response, Object handler,
            ModelAndView modelAndView) {

        List<Widget> widgets = WebUtils.findWidgets(request.getSession(false));

        if (widgets == null) {
            setDefaultWidget(request);
            return;
        }

        modelAndView.addObject(paramName, widgets);
    }

    private void setDefaultWidget(HttpServletRequest request) {
        request.setAttribute(paramName, DEFAULT_WIDGETS);
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }
}
