package org.unitedfront2.web.handler;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.User;
import org.unitedfront2.web.WebUtils;

/**
 * ANZXOL^C^[Zv^łB[ {@link TerminalChangeInterceptor} 
 * Ă܂BK {@link TerminalChangeInterceptor} ̌ɌĂяo悤ݒ肵ĂB
 *
 * @author kurokkie
 *
 */
@Repository(value = "accessLogInterceptor")
public class AccessLogInterceptor extends HandlerInterceptorAdapter {

    /** O */
    private static final Log LOGGER
        = LogFactory.getLog(AccessLogInterceptor.class);

    @Override
    public void afterCompletion(HttpServletRequest request,
            HttpServletResponse response, Object handler, Exception ex)
        throws Exception {

        StringBuffer sb = new StringBuffer(26);

        // Session ID
        HttpSession session = request.getSession(false);
        sb.append('\t');
        if (session != null) {
            sb.append(session.getId());
        } else {
            sb.append("null");
        }

        // IP Address
        sb.append('\t').append(request.getRemoteAddr());

        // Account ID
        Account account = WebUtils.findAccount(session);
        sb.append('\t');
        if (account != null) {
            sb.append(account.getId());
        } else {
            sb.append("null");
        }

        // User
        User user = WebUtils.findUser(session);
        sb.append('\t');
        if (user != null) {
            sb.append(user.getName());
        } else {
            sb.append("null");
        }

        // Locale
        Locale locale = WebUtils.getLocale(request);
        sb.append('\t').append(locale.getLanguage());

        // Terminal
        Object terminal = WebUtils.findTerminal(request);
        sb.append('\t').append(terminal);

        // request URI
        sb.append('\t').append(request.getRequestURI());

        LOGGER.info(sb);
    }
}
