package org.unitedfront2.web.controller.user;

import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.UserCodeUsedByOtherException;
import org.unitedfront2.domain.UserNameUsedByOtherException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;

/**
 * [UύX@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "user.changeAction")
public class ChangeAction extends MultiAction {

    /**
     * Tut[̂߂̏s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "user.Change");
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doChange");
        return success();
    }

    /**
     * [UύX܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws UserCodeUsedByOtherException [UR[hɎgpĂ
     * @throws UserNameUsedByOtherException [UɎgpĂ
     */
    public Event change(RequestContext context)
        throws UserCodeUsedByOtherException, UserNameUsedByOtherException {
        Account account = WebUtils.findAccount(context);
        SimpleUser user = (SimpleUser) context.getFlowScope()
            .get(FormAction.USER_PARAM_NAME);
        user.setId(account.getId());
        user.store();
        WebUtils.setUser(WebUtils.getRequest(context).getSession(), user);
        return success();
    }
}
