package org.unitedfront2.web.controller.profile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageCodeUsedByOtherException;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;

/**
 * ȏЉXVp̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "profile.selfIntroductionUpdateAction")
public class SelfIntroductionUpdateAction extends MultiAction {

    /** vtB[e[u */
    @Autowired private ProfileTable profileTable;

    /**
     * s̃bZ[WtH[ɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        User user = WebUtils.getUser(context);
        Profile profile = profileTable.get(user.getId());
        profile.retrieveSelfIntroduction();
        context.getFlowScope().put(
                org.unitedfront2.web.controller.message.FormAction
                        .MESSAGE_PARAM_NAME, profile.getSelfIntroduction());
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "profile.SelfIntroductionUpdateForm");
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doUpdate");
        return success();
    }

    /**
     * ȏЉXV܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event update(RequestContext context) {
        User user = WebUtils.getUser(context);
        Message message = (Message) context.getFlowScope().get("message");
        try {
            message.store();
        } catch (MessageCodeUsedByOtherException e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
        context.getFlowScope().put("user", user);
        return success();
    }
}
