package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.flow.AccessDeniedException;

/**
 * R~jeB̊{ύXANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.updateAction")
public class UpdateAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired private CommunityTable communityTable;

    /**
     * XVR~jeB肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws AccessDeniedException ҏWȂ
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws AccessDeniedException {
        Community c = Utils.findCommunityAndWriteAccess(context, this,
                communityTable, "communityCode");
        context.getFlowScope().put(FormAction.LAST_SUBMIT_CODE_PARAM_NAME,
            "doUpdate");
        context.getFlowScope().put(FormAction.COMMUNITY_PARAM_NAME, c);
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "community.UpdateForm");

        return success();
    }
}
