package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.util.HtmlUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.PageNotFoundException;
import org.unitedfront2.web.handler.TitleInterceptor;
import org.unitedfront2.web.tags.PagingTag;

/**
 * Xbh{ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.threadViewAction")
public class ThreadViewAction extends AbstractAction {

    /** Py[Wɕ\L */
    public static final int DISPLAY_COUNT = PagingTag.DEFAULT_DISPLAY_COUNT;

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    /**
     * R~jeBʂ̕\s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    @Override
    protected Event doExecute(RequestContext context) {
        Community community = Utils.findCommunity(context, this,
                communityTable, "communityCode");
        Thread t = Utils.findThreadAndReadAccess(context, this, community,
                "threadId");

        int page = context.getRequestParameters().getInteger("page", 0);
        t.retrieveEntries(page * DISPLAY_COUNT, DISPLAY_COUNT);
        t.retrieveCount();
        if (t.getEntries().size() == 0 && t.getCount() > 0) {
            String message = "The page " + page + " not found.";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }

        // L҂̕
        t.getOverview().retrieveAuthor();

        // ҂̕
        t.retrieveEntryAuthors();

        context.getRequestScope().put("community", community);
        context.getRequestScope().put("displayCount", DISPLAY_COUNT);
        context.getRequestScope().put("thread", t);
        context.getRequestScope().put(
                TitleInterceptor.TITLE_CODE_PARAM_NAME,
                "community.ThreadView");
        context.getRequestScope().put(
                TitleInterceptor.TITLE_ARGS_PARAM_NAME,
                new Object[] {
                        HtmlUtils.htmlEscape(t.getOverview().getSubject(
                                WebUtils.getLocale(context))),
                });
        context.getRequestScope().put("_feedUrl", "/community/"
                + community.getCode() + "/" + t.getId() + "/index.xml");
        return success();
    }
}
