package org.unitedfront2.web.controller.account;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.FormAction;

/**
 * pX[hύXANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "account.passwordChangeAction")
public class PasswordChangeAction extends FormAction {

    /** AJEge[u */
    @Autowired private AccountTable accountTable;

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(Account.class);
    }

    /**
     * pX[hύX܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event changePassword(RequestContext context) {
        Account account = (Account) getFormObject(context);
        account.setId(WebUtils.findAccount(context).getId());
        changePassword(account);
        return success();
    }

    private void changePassword(Account account) {
        account.encrypt();
        String newPassword = account.getPassword();
        Account foundAccount = accountTable.find(account.getId());
        foundAccount.setEncryptedPassword(newPassword);
        try {
            foundAccount.store();
        } catch (MailAddrUsedByOtherException e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    @Resource(name = "account.passwordChangeValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
