package org.unitedfront2.web.controller;

import java.io.Serializable;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.EmailForwarding;
import org.unitedfront2.domain.EmailForwardingTable;
import org.unitedfront2.domain.User;
import org.unitedfront2.web.WebUtils;

/**
 * []ݒ̍XVsANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "emailForwardingAction")
public class EmailForwardingAction extends FormAction {

    /** ]ݒr[ */
    public static class Settings implements Serializable {

        /** VAԍ */
        private static final long serialVersionUID = -7473358355044709686L;

        /** ]ݒ */
        private Map<EmailForwarding, Boolean> target;

        public Map<EmailForwarding, Boolean> getTarget() {
            return target;
        }

        public void setTarget(Map<EmailForwarding, Boolean> target) {
            this.target = target;
        }
    }

    /** e []ݒe[u */
    @Autowired private EmailForwardingTable emailForwardingTable;

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(Settings.class);
    }

    /**
     * tH[̃ZbgAbvs܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws Exception {@link Exception}
     */
    @Override
    public Event setupForm(RequestContext context) throws Exception {
        super.setupForm(context);
        User user = WebUtils.getUser(context);
        Settings settings = (Settings) getFormObject(context);
        Map<EmailForwarding, Boolean> map = emailForwardingTable.find(
                user.getId());
        settings.setTarget(map);
        return success();
    }

    /**
     * ݒXV܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event update(RequestContext context) {
        User user = WebUtils.getUser(context);
        Settings settings = (Settings) getFormObject(context);
        emailForwardingTable.update(user.getId(), settings.getTarget());
        context.getRequestScope().put("success", true);
        return success();
    }
}
