package org.unitedfront2.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.servlet.ServletContext;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.tiles.TilesException;

/**
 * Tiles `t@CzuĂpXݒ\ {@link
 * org.springframework.web.servlet.view.tiles2.TilesConfigurer} łB
 *
 * @author kurokkie
 *
 */
public class TilesConfigurer extends
        org.springframework.web.servlet.view.tiles2.TilesConfigurer {

    /** Tiles `t@C (tiles-defs.xml) */
    public static final String TILES_DEFS_FILE_NAME = "tiles-defs.xml";

    /** {@link ServletContext} */
    private ServletContext servletContext;

    /** Tiles `t@CzuĂpX */
    private String baseDir;

    @Override
    public void afterPropertiesSet() throws TilesException {
        setDefinitions();
        super.afterPropertiesSet();
    }

    private void setDefinitions() {
        File baseDir = new File(servletContext.getRealPath(this.baseDir));
        Collection<File> tilesDefs = FileUtils.listFiles(baseDir,
                new NameFileFilter(TILES_DEFS_FILE_NAME),
                TrueFileFilter.INSTANCE);
        List<String> list = new ArrayList<String>(tilesDefs.size());
        for (File f : tilesDefs) {
            list.add(f.getAbsolutePath()
                    .substring(servletContext.getRealPath("").length())
                    .replace(File.separatorChar, '/'));
        }
        Collections.sort(list, new Comparator<String>() {

            @Override
            public int compare(String s1, String s2) {
                int s1PathCount = StringUtils.countMatches(s1, "/");
                int s2PathCount = StringUtils.countMatches(s2, "/");
                if (s1PathCount == s2PathCount) {
                    return s1.compareTo(s2);
                } else if (s1PathCount < s2PathCount) {
                    return -1;
                } else {
                    return 1;
                }
            }
        });
        super.setDefinitions(list.toArray(new String[list.size()]));
    }

    /**
     * Tiles `t@CzuĂpXݒ肵܂Bj /WEB-INF/view
     *
     * @param baseDir@Tiles `t@CzuĂpX
     */
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void setDefinitions(String[] definitions) {
        throw new UnsupportedOperationException(
                "Cannot use this method. Use 'setBaseDir' method.");
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        super.setServletContext(servletContext);
    }
}
