package org.unitedfront2.domain.accesscontrol;

import java.util.Set;

import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.communication.Profile;
import org.unitedfront2.domain.communication.ProfileTable;

/**
 * FBƁAFB̗FB̂݃ANZXANZXNXłB
 *
 * @author kurokkie
 *
 */
public class FriendsOfFriendsOnly extends AbstractAccessControl {

    /** VAԍ */
    private static final long serialVersionUID = 2629465514167436405L;

    /** vtB[e[u */
    private transient ProfileTable profileTable;

    /**
     * <code>user</code> ̏L҂ƗFBłFB̗FBłȂꍇ̓ANZXۂ܂B
     *
     * @param resource 
     * @param userId ANZX҂̃[U ID
     * @throws AccessDeniedException L҂ƃANZX҂FBłFB̗FBłȂ
     */
    @Override
    protected void doAccess(Resource resource, int userId)
        throws AccessDeniedException {

        Profile profile = profileTable.find(resource.getOwnerId());
        Set<SimpleUser> fof = profile.getFriendsOfFriends();
        if (!exist(fof, userId)) {
            String message = "The user [ID=" + userId
                + "] is not a friend of the owner '" + resource.getOwnerId()
                + "'.";
            logger.warn(message);
            throw new AccessDeniedException(message);
        }
    }

    private boolean exist(Set<SimpleUser> users, int userId) {
        for (SimpleUser user : users) {
            if (user.getId() == userId) {
                return true;
            }
        }
        return false;
    }

    public void setProfileTable(ProfileTable profileTable) {
        this.profileTable = profileTable;
    }
}
