package org.unitedfront2.domain.accesscontrol;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.AccessControlDao;

/**
 * {@link AccessControl} ̒ۃNXłB̒ۃNX̃TuNX
 * {@link AccessControl#changeTo(Class)} \bhłȂ߁AANZXNXƂĂ
 * sSłBANZXύX\ɂ邽߂ɂ́A{@link AccessControlProxy} vLV
 * ėpKv܂B
 *
 * @author kurokkie
 *
 */
abstract class AbstractAccessControl implements AccessControl {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** ID */
    private Integer id;

    /** ANZXf[^ANZXIuWFNg */
    private transient AccessControlDao accessControlDao;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof AccessControl)) {
            return false;
        }
        AccessControl castOther = (AccessControl) other;
        return new EqualsBuilder().append(id, castOther.getId())
            .append(getType(), castOther.getType()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(id).append(getType()).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id)
            .append("type", getType()).toString();
    }

    /**
     * [UɃANZX܂BANZXꍇ͉N܂BL҂ɂANZX͋
     * ܂B̑̃[ŨANZX́A{@link #doAccess(Resource, int)} ɈϏ܂B
     *
     * @param resource 
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    @Override
    public final void access(Resource resource, int userId)
        throws AccessDeniedException {

        if (resource.getOwnerId() != null
                && userId == resource.getOwnerId().intValue()) {
            return;
        } else {
            doAccess(resource, userId);
        }
    }

    /**
     * [UɃANZX܂BANZXꍇ͉N܂BL҂܂͒҂ɂANZ
     * X͋܂B̑̃[ŨANZX́A{@link #doAccess(Resource, int)} ɈϏ܂B
     *
     * @param resource ҂݂鎑
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    @Override
    public final void access(CopyrightedResource resource, int userId)
        throws AccessDeniedException {

        if (resource.getOwnerId() != null && userId == resource.getOwnerId()) {
            return;
        } else if (resource.getAuthorId() != null
                && userId == resource.getAuthorId().intValue()) {
            return;
        } else {
            doAccess(resource, userId);
        }
    }

    /**
     * L҂܂͒҈ȊÕ[UɃANZXƂ̏܂B
     *
     * @param resource 
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    protected abstract void doAccess(Resource resource, int userId)
        throws AccessDeniedException;

    /**
     * ANZXۂ܂BKvɉăTuNXŃI[o[ChĂB
     *
     * @param resource 
     * @throws AccessDeniedException ANZX
     */
    @Override
    public void access(Resource resource) throws AccessDeniedException {
        String message
            = "Access deneied from anonymous user with the resource '"
                + resource + "'";
        logger.warn(message);
        throw new AccessDeniedException(message);
    }

    /**
     * ANZXۂ܂BKvɉăTuNXŃI[o[ChĂB
     *
     * @param resource 
     * @throws AccessDeniedException ANZX
     */
    @Override
    public void access(CopyrightedResource resource)
        throws AccessDeniedException {

        String message
            = "Access deneied from anonymous user with the resource '"
                + resource + "'";
        logger.warn(message);
        throw new AccessDeniedException(message);
    }

    @Override
    public boolean identify(AccessControl other) {
        if (id == null || other.getId() == null) {
            return false;
        }
        return id.equals(other.getId());
    }

    @Override
    public void store() {
        if (id == null) {
            accessControlDao.register(this);
        } else {
            accessControlDao.update(this);
        }
    }

    @Override
    public void delete() {
        accessControlDao.delete(id);
    }

    /**
     * ̃\bh̓T|[gĂ܂B
     *
     * @param clazz ύX̃ANZXNX
     * @throws UnsupportedOperationException K܂
     * @see AccessControlProxy
     */
    @Override
    public void changeTo(Class<? extends AccessControl> clazz)
        throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The class '" + getClass()
                + "' cannot change.");
    }

    @Override
    public Class<? extends AccessControl> getType() {
        return getClass();
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    protected AccessControlDao getAccessControlDao() {
        return accessControlDao;
    }

    public void setAccessControlDao(AccessControlDao accessControlDao) {
        this.accessControlDao = accessControlDao;
    }
}
