package org.unitedfront2.domain;

import java.io.Serializable;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * {@link User} IuWFNǧ؃NXłB
 *
 * @author kurokkie
 *
 */
public class SimpleUserValidator implements Serializable {

    /** VAԍ */
    private static final long serialVersionUID = 2429613321350328959L;

    /** [UR[h̍ő啶񒷂̃ftHgl (32) */
    public static final int DEFAULT_CODE_MAX_LENGTH = 32;

    /** [UR[h̐K\̃ftHgl ([0-9a-z]+) */
    public static final String DEFAULT_CODE_REGEX = "[0-9a-z]+";

    /** [U̍ő啶񒷂̃ftHgl (32) */
    public static final int DEFAULT_NAME_MAX_LENGTH = 32;

    /** [UR[h̍ő啶 */
    private int codeMaxLength = DEFAULT_CODE_MAX_LENGTH;

    /** [UR[h̐K\ */
    private String codeRegex = DEFAULT_CODE_REGEX;

    /** [U̍ő啶 */
    private int nameMaxLength = DEFAULT_NAME_MAX_LENGTH;

    /** [Ue[u */
    private transient SimpleUserTable simpleUserTable;

    @Override
    public String toString() {
        return new ToStringBuilder(this)
            .append("codeMaxLength", codeMaxLength)
            .append("codeRegex", codeRegex)
            .append("nameMaxLength", nameMaxLength).toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof SimpleUserValidator)) {
            return false;
        }
        SimpleUserValidator castOther = (SimpleUserValidator) other;
        return new EqualsBuilder()
            .append(codeMaxLength, castOther.codeMaxLength)
            .append(codeRegex, castOther.codeRegex)
            .append(nameMaxLength, castOther.nameMaxLength).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(codeMaxLength)
            .append(codeRegex)
            .append(nameMaxLength).toHashCode();
    }

    /**
     * [UR[ȟ؂s܂B<p>
     *
     * ؓe
     * <ul>
     *   <li>K{</li>
     *   <li>ő啶</li>
     *   <li>K\</li>
     *   <li></li>
     * </ul>
     *
     * @param user [U
     * @throws ValidationException ؗO
     */
    public void validateCode(SimpleUser user) throws ValidationException {
        String code = user.getCode();
        Validate.notBlank(code);
        Validate.maxLength(code, codeMaxLength);
        Validate.match(code, codeRegex);
        SimpleUser found = simpleUserTable.findByCode(code);
        if (found != null && !user.identify(found)) {
            throw new ValidationException("user.validation.userCodeUsedByOther",
                    null, "The code '" + code + "' is used by other");
        }
    }

    /**
     * [Ǔ؂s܂B<p>
     *
     * ؓe
     * <ul>
     *   <li>K{</li>
     *   <li>ő啶</li>
     *   <li>Ő</li>
     *   <li></li>
     * </ul>
     *
     * @param user [U
     * @throws ValidationException ؗO
     */
    public void validateName(SimpleUser user) throws ValidationException {
        String name = user.getName();
        Validate.notBlank(name);
        Validate.maxLength(name, nameMaxLength);
        Validate.notAroundSpaces(name);
        SimpleUser found = simpleUserTable.findByName(name);
        if (found != null && !user.identify(found)) {
            throw new ValidationException("user.validation.userNameUsedByOther",
                    null, "The name '" + name + "' is used by other.");
        }
    }

    public int getCodeMaxLength() {
        return codeMaxLength;
    }

    public void setCodeMaxLength(int codeMaxLength) {
        this.codeMaxLength = codeMaxLength;
    }

    public String getCodeRegex() {
        return codeRegex;
    }

    public void setCodeRegex(String codeRegex) {
        this.codeRegex = codeRegex;
    }

    public int getNameMaxLength() {
        return nameMaxLength;
    }

    public void setNameMaxLength(int nameMaxLength) {
        this.nameMaxLength = nameMaxLength;
    }

    public void setSimpleUserTable(SimpleUserTable simpleUserTable) {
        this.simpleUserTable = simpleUserTable;
    }
}
