package org.unitedfront2.domain.communication;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.SimpleTableModule;
import org.unitedfront2.test.TableModuleTestCaseSupport;

public class MailTableTest extends TableModuleTestCaseSupport<Mail> {

    @Autowired private MailTable mailTable;

    @Override
    protected Mail createDomain() {
        Mail mail = domainFactory.prototype(Mail.class);
        mail.setToId(simpleUser1.getId());
        mail.setFromId(simpleUser2.getId());
        mail.setSubject("Subject");
        mail.setBody("This is body.");
        return mail;
    }

    @Override
    protected SimpleTableModule<Mail> getTableModule() {
        return mailTable;
    }

    @Override
    protected SimpleFindable<Mail> getSimpleDao() {
        return mailTable.getSimpleDao();
    }

    @Test
    public void testFindThread() {
        Mail mail = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."));
        mail.send();

        Mail found = mailTable.findThread(mail.getId());
        Assert.assertEquals(mail, found);
    }

    @Test
    public void testFindThreadȂ() {
        Assert.assertNull(mailTable.findThread(-1));
    }

    @Test
    public void testGetThread() {
        Mail mail = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."));
        mail.send();

        Mail found = mailTable.getThread(mail.getId());
        Assert.assertEquals(mail, found);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetThreadȂ() {
        mailTable.getThread(-1);
    }

    @Test
    public void testFindThreadByCode() {
        Mail mail = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."));
        mail.send();

        Mail found = mailTable.findThreadByCode(mail.getCode());
        Assert.assertEquals(mail, found);
    }

    @Test
    public void testFindThreadByCodeȂ() {
        Assert.assertNull(mailTable.findThreadByCode(""));
    }

    @Test
    public void testGetThreadByCode() {
        Mail mail = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."));
        mail.send();

        Mail found = mailTable.getThreadByCode(mail.getCode());
        Assert.assertEquals(mail, found);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetThreadByCodeȂ() {
        mailTable.getThreadByCode("");
    }

    @Test
    public void testRetrieveUsers() {
        Mail mail1 = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."));
        mail1.send();
        Mail mail2 = domainFactory.prototype(new Mail(simpleUser1.getId(), simpleUser2.getId(), "Subject", "This is a body."));
        mail2.send();
        List<Mail> list = new ArrayList<Mail>();
        list.add(mail1);
        list.add(mail2);

        Mail.retrieveUsers(list);
        Assert.assertEquals(simpleUser1, mail1.getTo());
        Assert.assertEquals(simpleUser2, mail1.getFrom());
        Assert.assertEquals(simpleUser1, mail2.getTo());
        Assert.assertEquals(simpleUser2, mail2.getFrom());
    }
}
