package org.unitedfront2.domain.accesscontrol;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.test.TransactionalTestCase;

public class AccessControlProxyTest extends TransactionalTestCase {

    @Test
    public void testChangeToύXł() {
        AccessControl accessControl = domainFactory.prototype(Public.class);
        accessControl.store();
        Assert.assertSame(Public.class, accessControl.getType());
        accessControl.changeTo(UserOnly.class);
        Assert.assertSame(UserOnly.class, accessControl.getType());
    }

    @Test
    public void testChangeToIDnull̃ANZXIuWFNg̎ނύXł() {
        AccessControl accessControl = domainFactory.prototype(Public.class);
        Assert.assertSame(Public.class, accessControl.getType());
        accessControl.changeTo(UserOnly.class);
        Assert.assertSame(UserOnly.class, accessControl.getType());
    }

    @Test
    public void testEquals() {
        AccessControl ac1 = domainFactory.prototype(Public.class);
        AccessControl ac2 = domainFactory.prototype(Public.class);
        Assert.assertNotSame(ac1, ac2);
        Assert.assertEquals(ac1, ac2);
    }
}
