package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.Account.Status;
import org.unitedfront2.test.TransactionalTestCase;

public class SimpleUserTest extends TransactionalTestCase {

    private Account account;

    private SimpleUser simpleUser;

    @Autowired private SimpleUserTable simpleUserTable;

    @Before
    public void onSetUpInTransaction() throws MailAddrUsedByOtherException {
        account = new Account("tester@unitedfront2.org", "password", Status.AVAILABLE, Role.ROLE_USER);
        account.encrypt();
        account = domainFactory.prototype(account);
        account.store();
        simpleUser = domainFactory.prototype(new SimpleUser(account.getId(), "tester", "eX^["));
    }

    @Test
    public void testUpdateXV() throws UserCodeUsedByOtherException, UserNameUsedByOtherException {
        simpleUserTable.install(simpleUser);
        simpleUser.setCode("new_" + simpleUser.getCode());
        simpleUser.setName("new_" + simpleUser.getName());

        Assert.assertNotNull(simpleUser.getId());
        Assert.assertNotNull(simpleUser.getCode());
        Assert.assertNotNull(simpleUser.getName());
        Assert.assertTrue(simpleUserTable.exist(simpleUser.getId()));
        simpleUser.store();
        Assert.assertEquals(simpleUserTable.get(simpleUser.getId()), simpleUser);
    }

    @Test(expected=UserCodeUsedByOtherException.class)
    public void testUpdateXV݂邪[UR[h̃[UɂĊɎgpĂ() throws UserCodeUsedByOtherException, UserNameUsedByOtherException, MailAddrUsedByOtherException {
        simpleUserTable.install(simpleUser);
        Account account2 = domainFactory.prototype(account);
        account2.setId(null);
        account2.setMailAddr("new_" + account2.getMailAddr());
        account2.store();
        SimpleUser user2 = domainFactory.prototype(simpleUser);
        user2.setId(account2.getId());
        user2.setCode("new_" + simpleUser.getCode());
        user2.setName("new_" + simpleUser.getName());
        simpleUserTable.install(user2);
        user2.setCode(simpleUser.getCode());

        Assert.assertNotNull(user2.getId());
        Assert.assertNotNull(user2.getCode());
        Assert.assertNotNull(user2.getName());
        Assert.assertNotNull(simpleUserTable.exist(user2.getId()));
        user2.store();
    }

    @Test(expected=UserNameUsedByOtherException.class)
    public void testUpdateXV݂邪[Ũ[UɂĊɎgpĂ() throws UserCodeUsedByOtherException, UserNameUsedByOtherException, MailAddrUsedByOtherException {
        simpleUserTable.install(simpleUser);
        Account account2 = domainFactory.prototype(account);
        account2.setId(null);
        account2.setMailAddr("new_" + account2.getMailAddr());
        account2.store();
        SimpleUser tmp = domainFactory.prototype(simpleUser);
        tmp.setId(account2.getId());
        tmp.setCode("new_" + simpleUser.getCode());
        tmp.setName("new_" + simpleUser.getName());
        SimpleUser user2 = domainFactory.prototype(tmp);
        simpleUserTable.install(user2);
        tmp.setName(simpleUser.getName());
        user2 = domainFactory.prototype(tmp);

        Assert.assertNotNull(user2.getId());
        Assert.assertNotNull(user2.getCode());
        Assert.assertNotNull(user2.getName());
        Assert.assertNotNull(simpleUserTable.exist(user2.getId()));
        user2.store();
    }

    @Test
    public void testIsActiveŏIANZXnullȂfalse() {
        simpleUser.setLastAccessDate(null);
        Assert.assertFalse(simpleUser.isActive());
    }

    @Test
    public void testIsActiveTrue() throws UserCodeUsedByOtherException, UserNameUsedByOtherException {
        simpleUserTable.setActiveInterSpace(1000);
        simpleUser.setActiveInterSpace(1000);
        simpleUserTable.install(simpleUser);
        simpleUser.touch();
        simpleUser = simpleUserTable.get(simpleUser.getId());
        Assert.assertTrue(simpleUser.isActive());
    }

    @Test
    public void testIsActiveFalse() throws InterruptedException, UserCodeUsedByOtherException, UserNameUsedByOtherException {
        simpleUserTable.setActiveInterSpace(1000);
        simpleUserTable.install(simpleUser);
        simpleUser.touch();
        Thread.sleep(1000);
        simpleUser = simpleUserTable.get(simpleUser.getId());
        simpleUser.setActiveInterSpace(1000);
        Assert.assertFalse(simpleUser.isActive());
    }
}
