package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.Account.Status;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class SimpleUserTableTest extends TransactionalTestCaseWithInitialData {

    @Autowired private SimpleUserTable simpleUserTable;

    @Test
    public void testFindByCode() {
        User foundUser = simpleUserTable.findByCode(simpleUser1.getCode());
        Assert.assertEquals(simpleUser1, foundUser);
    }

    @Test
    public void testFindByCodeȂ() {
        Assert.assertNull(simpleUserTable.findByCode("_notFound"));
    }

    @Test
    public void testGetByCode() {
        User foundUser = simpleUserTable.getByCode(simpleUser1.getCode());
        Assert.assertEquals(simpleUser1, foundUser);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByCodeȂ() {
        simpleUserTable.getByCode("_notFound");
    }

    @Test
    public void testExistsByCode() {
        Assert.assertTrue(simpleUserTable.existsByCode(simpleUser1.getCode()));
    }

    @Test
    public void testExistsByCodeȂ() {
        Assert.assertFalse(simpleUserTable.existsByCode("_notFound"));
    }

    @Test
    public void testFindByName() {
        User foundUser = simpleUserTable.findByName(simpleUser1.getName());
        Assert.assertEquals(simpleUser1, foundUser);
    }

    @Test
    public void testFindByNameȂ() {
        Assert.assertNull(simpleUserTable.findByName("_notFound"));
    }

    @Test
    public void testGetByName() {
        User foundUser = simpleUserTable.getByName(simpleUser1.getName());
        Assert.assertEquals(simpleUser1, foundUser);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByNameȂ() {
        simpleUserTable.getByName("_notFound");
    }

    @Test
    public void testExistsByName() {
        Assert.assertTrue(simpleUserTable.existsByName(simpleUser1.getName()));
    }

    @Test
    public void testExistsByNameȂ() {
        Assert.assertFalse(simpleUserTable.existsByName("_notFound"));
    }

    @Test
    public void testCountActiveUser() throws InterruptedException {
        simpleUser1.touch();
        Thread.sleep(2000);
        simpleUser2.touch();
        simpleUser3.touch();
        simpleUserTable.setActiveInterSpace(1000);

        int count = simpleUserTable.countActiveUser();
        Assert.assertSame(2, count);
    }

    @Test
    public void testInstall() throws MailAddrUsedByOtherException, UserCodeUsedByOtherException, UserNameUsedByOtherException {
        Account account = new Account("tester@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        account.encrypt();
        account = domainFactory.prototype(account);
        account.store();
        SimpleUser user = domainFactory.prototype(new SimpleUser(account.getId(), "tester", "eX^["));

        Assert.assertNull(simpleUserTable.find(account.getId()));
        Assert.assertNotNull(user.getId());
        Assert.assertNotNull(user.getClass());
        Assert.assertNotNull(user.getName());
        simpleUserTable.install(user);
        Assert.assertEquals(simpleUserTable.get(user.getId()), user);
    }

    @Test(expected=UserCodeUsedByOtherException.class)
    public void testInstallR[hgpĂ() throws MailAddrUsedByOtherException, UserCodeUsedByOtherException, UserNameUsedByOtherException {
        Account account1 = new Account("tester1@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        account1.encrypt();
        account1 = domainFactory.prototype(account1);
        account1.store();
        SimpleUser user1 = domainFactory.prototype(new SimpleUser(account1.getId(), "tester", "eX^["));
        simpleUserTable.install(user1);
        Account account2 = domainFactory.prototype(new Account("tester2@example.com", "password", Status.AVAILABLE, Role.ROLE_USER));
        account2.encrypt();
        account2.store();
        SimpleUser user2 = domainFactory.prototype(new SimpleUser(account2.getId(), "tester", "eX^[2"));
        simpleUserTable.install(user2);
    }

    @Test(expected=UserNameUsedByOtherException.class)
    public void testInstallOgpĂ() throws MailAddrUsedByOtherException, UserCodeUsedByOtherException, UserNameUsedByOtherException {
        Account account1 = new Account("tester1@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        account1.encrypt();
        account1 = domainFactory.prototype(account1);
        account1.store();
        SimpleUser user1 = domainFactory.prototype(new SimpleUser(account1.getId(), "simpletester", "eX^["));
        simpleUserTable.install(user1);
        Account account2 = new Account("tester2@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        account2.encrypt();
        account2 = domainFactory.prototype(account2);
        account2.store();
        SimpleUser user2 = domainFactory.prototype(new SimpleUser(account2.getId(), "simpletester2", "eX^["));
        simpleUserTable.install(user2);
    }
}
