package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.Account.Status;
import org.unitedfront2.test.TransactionalTestCase;

public class DomainFactoryTest extends TransactionalTestCase {

    @Autowired private DomainFactory domainFactory;

    @Test
    public void testPrototypeClass() {
        Account a = domainFactory.prototype(Account.class);
        Assert.assertNotNull(a);
    }

    @Test
    public void testPrototypeObject() {
        Account orig = new Account("tester@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        orig.encrypt();
        Account a = domainFactory.prototype(orig);
        Assert.assertNotNull(a);
        Assert.assertNotSame(orig, a);
        Assert.assertEquals(orig, a);
    }

    @Test
    public void testPrototypeObjectقȂCX^X𐶐Ă() throws MailAddrUsedByOtherException {
        Account orig = new Account("tester@example.com", "password", Status.AVAILABLE, Role.ROLE_USER);
        orig.encrypt();
        orig = domainFactory.prototype(orig);
        orig.store();
        orig.retrieveTemporaryAuthKey();
        Account a1 = domainFactory.prototype(orig);
        Account a2 = domainFactory.prototype(orig);
        Assert.assertNotSame(a1, a2);
        Assert.assertEquals(a1, a2);
    }
}
