package org.unitedfront2.web.tags;

import java.util.Collection;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.unitedfront2.domain.User;

/**
 * z܂̓RNV̒ɌΏۂ̃[U܂܂Ă邩ǂŏs^OłB܂܂Ă
 * Ζ{]A܂܂ĂȂΕ]܂B
 *
 * @author kurokkie
 *
 */
public class UserExistsTag extends TagSupport {

    /** VAԍ */
    private static final long serialVersionUID = -5002330546124427958L;

    /** z */
    private User[] array;

    /** RNV */
    private Collection<User> collection;

    /** Ώۂ̃[U */
    private User user;

    @Override
    public int doStartTag() throws JspException {
        if (contains()) {
            return EVAL_BODY_INCLUDE;
        } else {
            return SKIP_BODY;
        }
    }

    /**
     * z܂̓RNVɌΏۂ̃IuWFNg܂܂Ă邩ǂ𔻒肵܂B
     *
     * @return z܂̓RNVɌΏۂ̃IuWFNg܂܂Ă
     *     <code>true</code> AłȂ <code>true</code>
     */
    protected boolean contains() {
        if (array != null) {
            for (User u : array) {
                if (u.identify(user)) {
                    return true;
                }
            }
            return false;
        } else if (collection != null) {
            for (User u : collection) {
                if (u.identify(user)) {
                    return true;
                }
            }
            return false;
        } else {
            throw new IllegalStateException(
                    "The property 'users' must be set.");
        }
    }

    public void setUsers(User[] users) {
        this.array = users.clone();
    }

    public void setUsers(Collection<User> users) {
        this.collection = users;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
